/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.block.FixedWidthBlockCursor;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public abstract class AbstractFixedWidthBlock
implements Block {
    protected final FixedWidthType type;
    protected final int entrySize;

    protected AbstractFixedWidthBlock(FixedWidthType type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.entrySize = AbstractFixedWidthBlock.valueOffset(type.getFixedSize());
    }

    protected abstract Slice getRawSlice();

    @Override
    public FixedWidthType getType() {
        return this.type;
    }

    @Override
    public int getSizeInBytes() {
        return this.getRawSlice().length();
    }

    @Override
    public BlockCursor cursor() {
        return new FixedWidthBlockCursor(this.type, this.getPositionCount(), this.getRawSlice());
    }

    @Override
    public BlockEncoding getEncoding() {
        return new FixedWidthBlockEncoding(this.type);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public boolean getBoolean(int position) {
        this.checkReadablePosition(position);
        return this.type.getBoolean(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(this.entryOffset(position)));
    }

    @Override
    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.type.getLong(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(this.entryOffset(position)));
    }

    @Override
    public double getDouble(int position) {
        this.checkReadablePosition(position);
        return this.type.getDouble(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(this.entryOffset(position)));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return null;
        }
        return this.type.getObjectValue(session, this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(this.entryOffset(position)));
    }

    @Override
    public Slice getSlice(int position) {
        this.checkReadablePosition(position);
        return this.type.getSlice(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(this.entryOffset(position)));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(), (int)this.entryOffset(position), (int)this.entrySize);
        return new FixedWidthBlock(this.type, 1, copy);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryAtOffsetNull(this.entryOffset(position));
    }

    @Override
    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.entryOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftEntryOffset);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull != rightIsNull) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        return otherBlock.equalTo(otherPosition, this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(leftEntryOffset));
    }

    @Override
    public boolean equalTo(int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        int entryOffset = this.entryOffset(position);
        boolean thisIsNull = this.isEntryAtOffsetNull(entryOffset);
        boolean valueIsNull = cursor.isNull();
        if (thisIsNull != valueIsNull) {
            return false;
        }
        if (thisIsNull) {
            return true;
        }
        return this.type.equalTo(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(entryOffset), cursor);
    }

    @Override
    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.entryOffset(position);
        return this.type.equalTo(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(leftEntryOffset), otherSlice, otherOffset);
    }

    @Override
    public int hash(int position) {
        this.checkReadablePosition(position);
        int entryOffset = this.entryOffset(position);
        if (this.isEntryAtOffsetNull(entryOffset)) {
            return 0;
        }
        return this.type.hash(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(entryOffset));
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.entryOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftEntryOffset);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -otherBlock.compareTo(otherPosition, this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(leftEntryOffset));
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.entryOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftEntryOffset);
        boolean rightIsNull = cursor.isNull();
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -cursor.compareTo(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(leftEntryOffset));
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.entryOffset(position);
        return this.type.compareTo(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(leftEntryOffset), otherSlice, otherOffset);
    }

    @Override
    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        int entryOffset = this.entryOffset(position);
        if (this.isEntryAtOffsetNull(entryOffset)) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.getRawSlice(), AbstractFixedWidthBlock.valueOffset(entryOffset), blockBuilder);
        }
    }

    private int entryOffset(int position) {
        return position * this.entrySize;
    }

    private boolean isEntryAtOffsetNull(int entryOffset) {
        return this.getRawSlice().getByte(entryOffset) != 0;
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalStateException("position is not valid");
        }
    }

    private static int valueOffset(int entryOffset) {
        return entryOffset + 1;
    }
}

