/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.classloader.ClassLoaderSafeRecordSet;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSetProvider(ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public boolean canHandle(Split split) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(split);
            return bl;
        }
    }

    @Override
    public RecordSet getRecordSet(Split split, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(split, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

