/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Domain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TupleDomain {
    private static final TupleDomain NONE = new TupleDomain(null);
    private static final TupleDomain ALL = new TupleDomain(Collections.emptyMap());
    private final Map<ColumnHandle, Domain> domains;

    private TupleDomain(Map<ColumnHandle, Domain> domains) {
        this.domains = domains == null || TupleDomain.containsNoneDomain(domains) ? null : Collections.unmodifiableMap(TupleDomain.normalizeAndCopy(domains));
    }

    public static TupleDomain withColumnDomains(Map<ColumnHandle, Domain> domains) {
        return new TupleDomain(Objects.requireNonNull(domains, "domains is null"));
    }

    public static TupleDomain none() {
        return NONE;
    }

    public static TupleDomain all() {
        return ALL;
    }

    public static TupleDomain withFixedValues(Map<ColumnHandle, Comparable<?>> fixedValues) {
        HashMap<ColumnHandle, Domain> domains = new HashMap<ColumnHandle, Domain>();
        for (Map.Entry<ColumnHandle, Comparable<?>> entry : fixedValues.entrySet()) {
            domains.put(entry.getKey(), Domain.singleValue(entry.getValue()));
        }
        return TupleDomain.withColumnDomains(domains);
    }

    @JsonCreator
    public static TupleDomain fromNullableColumnDomains(@JsonProperty(value="nullableColumnDomains") List<ColumnDomain> nullableColumnDomains) {
        if (nullableColumnDomains == null) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(TupleDomain.toMap(nullableColumnDomains));
    }

    @JsonProperty
    public List<ColumnDomain> getNullableColumnDomains() {
        return this.domains == null ? null : TupleDomain.toList(this.domains);
    }

    private static Map<ColumnHandle, Domain> toMap(List<ColumnDomain> columnDomains) {
        HashMap<ColumnHandle, Domain> map = new HashMap<ColumnHandle, Domain>();
        for (ColumnDomain columnDomain : columnDomains) {
            if (map.containsKey(columnDomain.getColumnHandle())) {
                throw new IllegalArgumentException("Duplicate column handle!");
            }
            map.put(columnDomain.getColumnHandle(), columnDomain.getDomain());
        }
        return map;
    }

    private static List<ColumnDomain> toList(Map<ColumnHandle, Domain> columnDomains) {
        ArrayList<ColumnDomain> list = new ArrayList<ColumnDomain>();
        for (Map.Entry<ColumnHandle, Domain> entry : columnDomains.entrySet()) {
            list.add(new ColumnDomain(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    private static boolean containsNoneDomain(Map<ColumnHandle, Domain> domains) {
        for (Domain domain : domains.values()) {
            if (!domain.isNone()) continue;
            return true;
        }
        return false;
    }

    private static Map<ColumnHandle, Domain> normalizeAndCopy(Map<ColumnHandle, Domain> domains) {
        HashMap<ColumnHandle, Domain> map = new HashMap<ColumnHandle, Domain>();
        for (Map.Entry<ColumnHandle, Domain> entry : domains.entrySet()) {
            if (entry.getValue().isAll()) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @JsonIgnore
    public boolean isAll() {
        return this.domains != null && this.domains.isEmpty();
    }

    @JsonIgnore
    public boolean isNone() {
        return this.domains == null;
    }

    @JsonIgnore
    public Map<ColumnHandle, Domain> getDomains() {
        if (this.domains == null) {
            throw new IllegalStateException("Can not get column Domains from a none TupleDomain");
        }
        return this.domains;
    }

    public Map<ColumnHandle, Comparable<?>> extractFixedValues() {
        if (this.isNone()) {
            return Collections.emptyMap();
        }
        HashMap fixedValues = new HashMap();
        for (Map.Entry<ColumnHandle, Domain> entry : this.getDomains().entrySet()) {
            if (!entry.getValue().isSingleValue()) continue;
            fixedValues.put(entry.getKey(), entry.getValue().getSingleValue());
        }
        return fixedValues;
    }

    public TupleDomain intersect(TupleDomain other) {
        if (this.isNone() || other.isNone()) {
            return TupleDomain.none();
        }
        HashMap<ColumnHandle, Domain> intersected = new HashMap<ColumnHandle, Domain>(this.getDomains());
        for (Map.Entry<ColumnHandle, Domain> entry : other.getDomains().entrySet()) {
            Domain intersectionDomain = (Domain)intersected.get(entry.getKey());
            if (intersectionDomain == null) {
                intersected.put(entry.getKey(), entry.getValue());
                continue;
            }
            intersected.put(entry.getKey(), intersectionDomain.intersect(entry.getValue()));
        }
        return TupleDomain.withColumnDomains(intersected);
    }

    public static TupleDomain columnWiseUnion(TupleDomain first, TupleDomain second, TupleDomain ... rest) {
        ArrayList<TupleDomain> domains = new ArrayList<TupleDomain>();
        domains.add(first);
        domains.add(second);
        domains.addAll(Arrays.asList(rest));
        return TupleDomain.columnWiseUnion(domains);
    }

    public static TupleDomain columnWiseUnion(List<TupleDomain> tupleDomains) {
        TupleDomain domain;
        if (tupleDomains.isEmpty()) {
            throw new IllegalArgumentException("tupleDomains must have at least one element");
        }
        if (tupleDomains.size() == 1) {
            return tupleDomains.get(0);
        }
        HashSet<ColumnHandle> commonColumns = new HashSet<ColumnHandle>();
        boolean found = false;
        Iterator<TupleDomain> domains = tupleDomains.iterator();
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            found = true;
            commonColumns.addAll(domain.getDomains().keySet());
            break;
        }
        if (!found) {
            return TupleDomain.none();
        }
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            commonColumns.retainAll(domain.getDomains().keySet());
        }
        HashMap<ColumnHandle, ArrayList<Domain>> domainsByColumn = new HashMap<ColumnHandle, ArrayList<Domain>>();
        for (TupleDomain domain2 : tupleDomains) {
            if (domain2.isNone()) continue;
            for (Map.Entry<ColumnHandle, Domain> entry : domain2.getDomains().entrySet()) {
                if (!commonColumns.contains(entry.getKey())) continue;
                ArrayList<Domain> domainForColumn = (ArrayList<Domain>)domainsByColumn.get(entry.getKey());
                if (domainForColumn == null) {
                    domainForColumn = new ArrayList<Domain>();
                    domainsByColumn.put(entry.getKey(), domainForColumn);
                }
                domainForColumn.add(entry.getValue());
            }
        }
        HashMap<ColumnHandle, Domain> result = new HashMap<ColumnHandle, Domain>();
        for (Map.Entry entry : domainsByColumn.entrySet()) {
            result.put((ColumnHandle)entry.getKey(), Domain.union((List)entry.getValue()));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public boolean overlaps(TupleDomain other) {
        return !this.intersect(other).isNone();
    }

    public boolean contains(TupleDomain other) {
        return other.isNone() || TupleDomain.columnWiseUnion(this, other, new TupleDomain[0]).equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleDomain)) {
            return false;
        }
        TupleDomain that = (TupleDomain)o;
        return !(this.domains != null ? !this.domains.equals(that.domains) : that.domains != null);
    }

    public int hashCode() {
        return this.domains != null ? this.domains.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("TupleDomain:");
        if (this.isAll()) {
            builder.append("ALL");
        } else if (this.isNone()) {
            builder.append("NONE");
        } else {
            builder.append(this.domains);
        }
        return builder.toString();
    }

    public static class ColumnDomain {
        private final ColumnHandle columnHandle;
        private final Domain domain;

        @JsonCreator
        public ColumnDomain(@JsonProperty(value="columnHandle") ColumnHandle columnHandle, @JsonProperty(value="domain") Domain domain) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public ColumnHandle getColumnHandle() {
            return this.columnHandle;
        }

        @JsonProperty
        public Domain getDomain() {
            return this.domain;
        }
    }
}

