/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FixedSplitSource
implements SplitSource {
    private final String dataSourceName;
    private final List<Split> splits;
    private int offset;

    public FixedSplitSource(String dataSourceName, Iterable<? extends Split> splits) {
        this.dataSourceName = dataSourceName;
        if (splits == null) {
            throw new NullPointerException("splits is null");
        }
        ArrayList<Split> splitsList = new ArrayList<Split>();
        for (Split split : splits) {
            splitsList.add(split);
        }
        this.splits = Collections.unmodifiableList(splitsList);
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public List<Split> getNextBatch(int maxSize) throws InterruptedException {
        int remainingSplits = this.splits.size() - this.offset;
        int size = Math.min(remainingSplits, maxSize);
        List<Split> results = this.splits.subList(this.offset, this.offset + size);
        this.offset += size;
        return results;
    }

    @Override
    public boolean isFinished() {
        return this.offset >= this.splits.size();
    }
}

