/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.TupleDomain;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleDomain {
    private static final ColumnHandle A = new TestingColumnHandle("a");
    private static final ColumnHandle B = new TestingColumnHandle("b");
    private static final ColumnHandle C = new TestingColumnHandle("c");
    private static final ColumnHandle D = new TestingColumnHandle("d");
    private static final ColumnHandle E = new TestingColumnHandle("e");
    private static final ColumnHandle F = new TestingColumnHandle("f");

    @Test
    public void testNone() throws Exception {
        Assert.assertTrue((boolean)TupleDomain.none().isNone());
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.none(String.class))));
    }

    @Test
    public void testAll() throws Exception {
        Assert.assertTrue((boolean)TupleDomain.all().isAll());
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of()));
    }

    @Test
    public void testIntersection() throws Exception {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all(String.class)).put((Object)B, (Object)Domain.notNull(Double.class)).put((Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)D, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Double.valueOf(0.0)), (Range[])new Range[0]), (boolean)true)).build());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Comparable)((Object)"value"))).put((Object)B, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0))).put((Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)D, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Double.valueOf(10.0)), (Range[])new Range[0]), (boolean)false)).build());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Comparable)((Object)"value"))).put((Object)B, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0))).put((Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)D, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Double.valueOf(0.0), (boolean)true, (Comparable)Double.valueOf(10.0), (boolean)false), (Range[])new Range[0]), (boolean)false)).build());
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneIntersection() throws Exception {
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.all()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.all().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull(Long.class))).intersect(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull(Long.class)))), (Object)TupleDomain.none());
    }

    @Test
    public void testMismatchedColumnIntersection() throws Exception {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Double.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Double.valueOf(0.0)), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Double.valueOf(0.0)), (Range[])new Range[0]), (boolean)true), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")), (Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))));
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
    }

    @Test
    public void testColumnWiseUnion() throws Exception {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all(String.class)).put((Object)B, (Object)Domain.notNull(Double.class)).put((Object)C, (Object)Domain.onlyNull(Long.class)).put((Object)D, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)E, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Double.valueOf(0.0)), (Range[])new Range[0]), (boolean)true)).build());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Comparable)((Object)"value"))).put((Object)B, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0))).put((Object)C, (Object)Domain.notNull(Long.class)).put((Object)D, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)E, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Double.valueOf(10.0)), (Range[])new Range[0]), (boolean)false)).build());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all(String.class)).put((Object)B, (Object)Domain.notNull(Double.class)).put((Object)C, (Object)Domain.all(Long.class)).put((Object)D, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)E, (Object)Domain.all(Double.class)).build());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneColumnWiseUnion() throws Exception {
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.all(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull(Long.class))), (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull(Long.class))), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
    }

    @Test
    public void testMismatchedColumnWiseUnion() throws Exception {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Double.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Double.valueOf(0.0)), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Double.class)));
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)B, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)B, (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)B, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)B, (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0)))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none(String.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)B, (Object)Domain.none(String.class))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value2")), (Object)C, (Object)Domain.none(String.class))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")), (Object)C, (Object)Domain.none(String.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.singleValue((Comparable)((Object)"value")), (Object)C, (Object)Domain.none(String.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.none(String.class))));
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.all(String.class))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none(String.class))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.none(String.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.none(String.class))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)C, (Object)Domain.none(Double.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.none(String.class))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(Double.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(Double.class))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(String.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)C, (Object)Domain.all(Double.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(String.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)C, (Object)Domain.all(Double.class))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(String.class)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)C, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0)))));
    }

    @Test
    public void testIsNone() throws Exception {
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none(Long.class))).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class), (Object)B, (Object)Domain.none(Long.class))).isNone());
    }

    @Test
    public void testIsAll() throws Exception {
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)))).isAll());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all(Long.class))).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)), (Object)B, (Object)Domain.all(Long.class))).isAll());
    }

    @Test
    public void testExtractFixedValues() throws Exception {
        Assert.assertEquals((Map)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all(Double.class)).put((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))).put((Object)C, (Object)Domain.onlyNull(Long.class)).put((Object)D, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true)).build()).extractFixedValues(), (Map)ImmutableMap.of((Object)B, (Object)"value"));
    }

    @Test
    public void testSingleValuesMapToDomain() throws Exception {
        Assert.assertEquals((Object)TupleDomain.withFixedValues((Map)ImmutableMap.builder().put((Object)A, (Object)1L).put((Object)B, (Object)"value").put((Object)C, (Object)0.01).put((Object)D, (Object)true).build()), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)B, (Object)Domain.singleValue((Comparable)((Object)"value"))).put((Object)C, (Object)Domain.singleValue((Comparable)Double.valueOf(0.01))).put((Object)D, (Object)Domain.singleValue((Comparable)Boolean.valueOf(true))).build()));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        final ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule().addDeserializer(ColumnHandle.class, (JsonDeserializer)new JsonDeserializer<ColumnHandle>(){

            public ColumnHandle deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return (ColumnHandle)mapper.readValue(jsonParser, TestingColumnHandle.class);
            }
        }));
        TupleDomain tupleDomain = TupleDomain.all();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), TupleDomain.class));
        tupleDomain = TupleDomain.none();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), TupleDomain.class));
        tupleDomain = TupleDomain.withFixedValues((Map)ImmutableMap.of((Object)A, (Object)1L, (Object)B, (Object)"abc"));
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), TupleDomain.class));
    }

    private boolean overlaps(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDOmain2 = TupleDomain.withColumnDomains(domains2);
        return tupleDomain1.overlaps(tupleDOmain2);
    }

    private boolean contains(Map<ColumnHandle, Domain> superSet, Map<ColumnHandle, Domain> subSet) {
        TupleDomain superSetTupleDomain = TupleDomain.withColumnDomains(superSet);
        TupleDomain subSetTupleDomain = TupleDomain.withColumnDomains(subSet);
        return superSetTupleDomain.contains(subSetTupleDomain);
    }

    private boolean equals(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDOmain2 = TupleDomain.withColumnDomains(domains2);
        return tupleDomain1.equals((Object)tupleDOmain2);
    }
}

