/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortedRangeSet {
    @Test
    public void testEmptySet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.none(Long.class);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertTrue((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)rangeSet));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)0);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertEquals((Iterable)rangeSet.complement(), (Iterable)SortedRangeSet.all(Long.class));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testEntireSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.all(Long.class);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertTrue((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertEquals((Iterable)rangeSet.complement(), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded(Long.class)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testSingleValue() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.singleValue((Comparable)Long.valueOf(10L));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(10L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(10L))});
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertTrue((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet, (Iterable)ImmutableList.of((Object)Range.equal((Comparable)Long.valueOf(10L)))));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertEquals((Iterable)rangeSet.complement(), (Iterable)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded(Long.class)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(10L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(9L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testBoundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(10L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(0L)), Range.range((Comparable)Long.valueOf(9L), (boolean)true, (Comparable)Long.valueOf(11L), (boolean)false), Range.equal((Comparable)Long.valueOf(0L)), Range.range((Comparable)Long.valueOf(2L), (boolean)true, (Comparable)Long.valueOf(4L), (boolean)true), Range.range((Comparable)Long.valueOf(4L), (boolean)false, (Comparable)Long.valueOf(5L), (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((Comparable)Long.valueOf(0L)), (Object)Range.range((Comparable)Long.valueOf(2L), (boolean)true, (Comparable)Long.valueOf(5L), (boolean)true), (Object)Range.range((Comparable)Long.valueOf(9L), (boolean)true, (Comparable)Long.valueOf(11L), (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.range((Comparable)Long.valueOf(0L), (boolean)false, (Comparable)Long.valueOf(2L), (boolean)false), Range.range((Comparable)Long.valueOf(5L), (boolean)false, (Comparable)Long.valueOf(9L), (boolean)false), Range.greaterThanOrEqual((Comparable)Long.valueOf(11L))});
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet, (Iterable)normalizedResult));
        Assert.assertEquals((Iterable)rangeSet, (Iterable)SortedRangeSet.copyOf(Long.class, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertEquals((Iterable)rangeSet.complement(), (Iterable)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded(Long.class)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(7L))));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(9L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testUnboundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(10L)), (Range[])new Range[]{Range.lessThanOrEqual((Comparable)Long.valueOf(0L)), Range.range((Comparable)Long.valueOf(2L), (boolean)true, (Comparable)Long.valueOf(4L), (boolean)false), Range.range((Comparable)Long.valueOf(4L), (boolean)true, (Comparable)Long.valueOf(6L), (boolean)false), Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(2L), (boolean)false), Range.range((Comparable)Long.valueOf(9L), (boolean)false, (Comparable)Long.valueOf(11L), (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((Comparable)Long.valueOf(0L)), (Object)Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(6L), (boolean)false), (Object)Range.greaterThan((Comparable)Long.valueOf(9L)));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(0L), (boolean)false, (Comparable)Long.valueOf(1L), (boolean)true), (Range[])new Range[]{Range.range((Comparable)Long.valueOf(6L), (boolean)true, (Comparable)Long.valueOf(9L), (boolean)true)});
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet, (Iterable)normalizedResult));
        Assert.assertEquals((Iterable)rangeSet, (Iterable)SortedRangeSet.copyOf(Long.class, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.getType(), Long.class);
        Assert.assertEquals((Iterable)rangeSet.complement(), (Iterable)complement);
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded(Long.class)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(4L))));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Comparable)Long.valueOf(7L))));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).getSingleValue(), (Object)0L);
        try {
            SortedRangeSet.all(Long.class).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSpan() throws Exception {
        try {
            SortedRangeSet.none(Long.class).getSpan();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)SortedRangeSet.all(Long.class).getSpan(), (Object)Range.all(Long.class));
        Assert.assertEquals((Object)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).getSpan(), (Object)Range.equal((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).getSpan(), (Object)Range.range((Comparable)Long.valueOf(0L), (boolean)true, (Comparable)Long.valueOf(1L), (boolean)true));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(1L))}).getSpan(), (Object)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(1L))}).getSpan(), (Object)Range.all(Long.class));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.all(Long.class)));
        Assert.assertFalse((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.none(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.all(Long.class)));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.none(Long.class)));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertTrue((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.all(Long.class)));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.none(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).overlaps(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).overlaps(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).overlaps(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).overlaps(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.all(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.none(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all(Long.class).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.all(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.none(Long.class)));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none(Long.class).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.all(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.none(Long.class)));
        Assert.assertTrue((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.lessThan((Comparable)Long.valueOf(0L))})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).contains(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).contains(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).contains(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).contains(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).intersect(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).intersect(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.all(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).intersect(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L)), Range.equal((Comparable)Long.valueOf(3L))}).intersect(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(4L))})), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).intersect(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(4L))})), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(4L))}));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(0L), (boolean)true, (Comparable)Long.valueOf(4L), (boolean)false), (Range[])new Range[0]).intersect(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(3L))})), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.range((Comparable)Long.valueOf(3L), (boolean)false, (Comparable)Long.valueOf(4L), (boolean)false)}));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).intersect(SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(-1L)), (Range[])new Range[0]).intersect(SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(1L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(-1L), (boolean)true, (Comparable)Long.valueOf(1L), (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testUnion() throws Exception {
        this.assertUnion(SortedRangeSet.none(Long.class), SortedRangeSet.none(Long.class), SortedRangeSet.none(Long.class));
        this.assertUnion(SortedRangeSet.all(Long.class), SortedRangeSet.all(Long.class), SortedRangeSet.all(Long.class));
        this.assertUnion(SortedRangeSet.none(Long.class), SortedRangeSet.all(Long.class), SortedRangeSet.all(Long.class));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(3L))}), SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L)), Range.equal((Comparable)Long.valueOf(3L))}));
        this.assertUnion(SortedRangeSet.all(Long.class), SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), SortedRangeSet.all(Long.class));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(0L), (boolean)true, (Comparable)Long.valueOf(4L), (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(3L)), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all(Long.class), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).complement());
    }

    @Test
    public void testSubtract() throws Exception {
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).subtract(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).subtract(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.all(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).subtract(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))), (Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).complement());
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).subtract(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).complement());
        Assert.assertEquals((Iterable)SortedRangeSet.all(Long.class).subtract(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).subtract(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).subtract(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).subtract(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).subtract(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.none(Long.class).subtract(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).subtract(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).subtract(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).subtract(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).subtract(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)).subtract(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).subtract(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).subtract(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).subtract(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))), (Iterable)SortedRangeSet.singleValue((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).subtract(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))}).subtract(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).subtract(SortedRangeSet.all(Long.class)), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).subtract(SortedRangeSet.none(Long.class)), (Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).subtract(SortedRangeSet.singleValue((Comparable)Long.valueOf(0L))), (Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).subtract(SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L))})), (Iterable)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(0L), (boolean)false, (Comparable)Long.valueOf(1L), (boolean)false), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(1L))}));
        Assert.assertEquals((Iterable)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0]).subtract(SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(0L)), (Range[])new Range[0])), (Iterable)SortedRangeSet.none(Long.class));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableIterator() throws Exception {
        Iterator iterator = SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]).iterator();
        iterator.next();
        iterator.remove();
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        SortedRangeSet set = SortedRangeSet.all(Long.class);
        Assert.assertEquals((Iterable)set, (Iterable)((Iterable)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class)));
        set = SortedRangeSet.none(Double.class);
        Assert.assertEquals((Iterable)set, (Iterable)((Iterable)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class)));
        set = SortedRangeSet.singleValue((Comparable)((Object)"abc"));
        Assert.assertEquals((Iterable)set, (Iterable)((Iterable)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class)));
        set = SortedRangeSet.of((Range)Range.equal((Comparable)Boolean.valueOf(true)), (Range[])new Range[]{Range.equal((Comparable)Boolean.valueOf(false))});
        Assert.assertEquals((Iterable)set, (Iterable)((Iterable)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class)));
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assert.assertEquals((Iterable)first.union(second), (Iterable)expected);
        Assert.assertEquals((Iterable)SortedRangeSet.union((Iterable)ImmutableList.of((Object)first, (Object)second)), (Iterable)expected);
    }
}

