/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.Range;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRange {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMismatchedTypes() throws Exception {
        new Range(Marker.exactly((Comparable)Long.valueOf(1L)), Marker.exactly((Comparable)((Object)"a")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvertedBounds() throws Exception {
        new Range(Marker.exactly((Comparable)Long.valueOf(1L)), Marker.exactly((Comparable)Long.valueOf(0L)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLowerUnboundedOnly() throws Exception {
        new Range(Marker.lowerUnbounded(Long.class), Marker.lowerUnbounded(Long.class));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUpperUnboundedOnly() throws Exception {
        new Range(Marker.upperUnbounded(Long.class), Marker.upperUnbounded(Long.class));
    }

    @Test
    public void testSingleValue() throws Exception {
        Assert.assertTrue((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(1L), (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(2L), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Comparable)Double.valueOf(1.1), (boolean)true, (Comparable)Double.valueOf(1.1), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Comparable)((Object)"a"), (boolean)true, (Comparable)((Object)"a"), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Comparable)Boolean.valueOf(true), (boolean)true, (Comparable)Boolean.valueOf(true), (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Comparable)Boolean.valueOf(false), (boolean)true, (Comparable)Boolean.valueOf(true), (boolean)true).isSingleValue());
    }

    @Test
    public void testAllRange() throws Exception {
        Range range = Range.all(Long.class);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded(Long.class));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded(Long.class));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertTrue((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertTrue((boolean)range.includes(Marker.below((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.above((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testGreaterThanRange() throws Exception {
        Range range = Range.greaterThan((Comparable)Long.valueOf(1L));
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded(Long.class));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(2L))));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testGreaterThanOrEqualRange() throws Exception {
        Range range = Range.greaterThanOrEqual((Comparable)Long.valueOf(1L));
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded(Long.class));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(2L))));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testLessThanRange() throws Exception {
        Range range = Range.lessThan((Comparable)Long.valueOf(1L));
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded(Long.class));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.below((Comparable)Long.valueOf(1L)));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testLessThanOrEqualRange() throws Exception {
        Range range = Range.lessThanOrEqual((Comparable)Long.valueOf(1L));
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded(Long.class));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(2L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testEqualRange() throws Exception {
        Range range = Range.equal((Comparable)Long.valueOf(1L));
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertTrue((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(2L))));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testRange() throws Exception {
        Range range = Range.range((Comparable)Long.valueOf(0L), (boolean)false, (Comparable)Long.valueOf(2L), (boolean)true);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Comparable)Long.valueOf(2L)));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), Long.class);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded(Long.class)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(1L))));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(2L))));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Comparable)Long.valueOf(3L))));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded(Long.class)));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)Range.equal((Comparable)Long.valueOf(0L)).getSingleValue(), (Object)0L);
        try {
            Range.lessThan((Comparable)Long.valueOf(0L)).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)Range.all(Long.class).contains(Range.all(Long.class)));
        Assert.assertTrue((boolean)Range.all(Long.class).contains(Range.equal((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Range.all(Long.class).contains(Range.greaterThan((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Range.equal((Comparable)Long.valueOf(0L)).contains(Range.equal((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Range.equal((Comparable)Long.valueOf(0L)).contains(Range.greaterThan((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Range.equal((Comparable)Long.valueOf(0L)).contains(Range.greaterThanOrEqual((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Range.equal((Comparable)Long.valueOf(0L)).contains(Range.all(Long.class)));
        Assert.assertTrue((boolean)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)).contains(Range.greaterThan((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Range.greaterThan((Comparable)Long.valueOf(0L)).contains(Range.greaterThan((Comparable)Long.valueOf(1L))));
        Assert.assertFalse((boolean)Range.greaterThan((Comparable)Long.valueOf(0L)).contains(Range.lessThan((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Range.range((Comparable)Integer.valueOf(0), (boolean)true, (Comparable)Integer.valueOf(2), (boolean)true).contains(Range.range((Comparable)Integer.valueOf(1), (boolean)true, (Comparable)Integer.valueOf(2), (boolean)true)));
        Assert.assertFalse((boolean)Range.range((Comparable)Integer.valueOf(0), (boolean)true, (Comparable)Integer.valueOf(2), (boolean)true).contains(Range.range((Comparable)Integer.valueOf(1), (boolean)true, (Comparable)Integer.valueOf(3), (boolean)false)));
    }

    @Test
    public void testSpan() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Long.valueOf(1L)).span(Range.lessThanOrEqual((Comparable)Long.valueOf(2L))), (Object)Range.all(Long.class));
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Long.valueOf(2L)).span(Range.lessThanOrEqual((Comparable)Long.valueOf(0L))), (Object)Range.all(Long.class));
        Assert.assertEquals((Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).span(Range.equal((Comparable)Long.valueOf(2L))), (Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false));
        Assert.assertEquals((Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).span(Range.range((Comparable)Long.valueOf(2L), (boolean)false, (Comparable)Long.valueOf(10L), (boolean)false)), (Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(10L), (boolean)false));
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Long.valueOf(1L)).span(Range.equal((Comparable)Long.valueOf(0L))), (Object)Range.greaterThanOrEqual((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Long.valueOf(1L)).span(Range.greaterThanOrEqual((Comparable)Long.valueOf(10L))), (Object)Range.greaterThan((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Range.lessThan((Comparable)Long.valueOf(1L)).span(Range.lessThanOrEqual((Comparable)Long.valueOf(1L))), (Object)Range.lessThanOrEqual((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Range.all(Long.class).span(Range.lessThanOrEqual((Comparable)Long.valueOf(1L))), (Object)Range.all(Long.class));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)Range.greaterThan((Comparable)Long.valueOf(1L)).overlaps(Range.lessThanOrEqual((Comparable)Long.valueOf(2L))));
        Assert.assertFalse((boolean)Range.greaterThan((Comparable)Long.valueOf(2L)).overlaps(Range.lessThan((Comparable)Long.valueOf(2L))));
        Assert.assertTrue((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).overlaps(Range.equal((Comparable)Long.valueOf(2L))));
        Assert.assertTrue((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).overlaps(Range.range((Comparable)Long.valueOf(2L), (boolean)false, (Comparable)Long.valueOf(10L), (boolean)false)));
        Assert.assertFalse((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).overlaps(Range.range((Comparable)Long.valueOf(3L), (boolean)true, (Comparable)Long.valueOf(10L), (boolean)false)));
        Assert.assertTrue((boolean)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)true).overlaps(Range.range((Comparable)Long.valueOf(3L), (boolean)true, (Comparable)Long.valueOf(10L), (boolean)false)));
        Assert.assertTrue((boolean)Range.all(Long.class).overlaps(Range.equal((Comparable)Long.valueOf(Long.MAX_VALUE))));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Long.valueOf(1L)).intersect(Range.lessThanOrEqual((Comparable)Long.valueOf(2L))), (Object)Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(2L), (boolean)true));
        Assert.assertEquals((Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).intersect(Range.equal((Comparable)Long.valueOf(2L))), (Object)Range.equal((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).intersect(Range.range((Comparable)Long.valueOf(2L), (boolean)false, (Comparable)Long.valueOf(10L), (boolean)false)), (Object)Range.range((Comparable)Long.valueOf(2L), (boolean)false, (Comparable)Long.valueOf(3L), (boolean)false));
        Assert.assertEquals((Object)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)true).intersect(Range.range((Comparable)Long.valueOf(3L), (boolean)true, (Comparable)Long.valueOf(10L), (boolean)false)), (Object)Range.equal((Comparable)Long.valueOf(3L)));
        Assert.assertEquals((Object)Range.all(Long.class).intersect(Range.equal((Comparable)Long.valueOf(Long.MAX_VALUE))), (Object)Range.equal((Comparable)Long.valueOf(Long.MAX_VALUE)));
    }

    @Test
    public void testExceptionalIntersect() throws Exception {
        try {
            Range.greaterThan((Comparable)Long.valueOf(2L)).intersect(Range.lessThan((Comparable)Long.valueOf(2L)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)false).intersect(Range.range((Comparable)Long.valueOf(3L), (boolean)true, (Comparable)Long.valueOf(10L), (boolean)false));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Range range = Range.all(Long.class);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.equal((Comparable)Double.valueOf(0.123));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThan((Comparable)Long.valueOf(0L));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThanOrEqual((Comparable)((Object)"abc"));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThanOrEqual((Comparable)Double.valueOf(Double.MAX_VALUE));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
    }
}

