/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Map;

public class ClassLoaderSafeConnectorMetadata
implements ConnectorMetadata {
    private final ConnectorMetadata delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorMetadata(ConnectorMetadata delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    @Override
    public boolean canHandle(TableHandle tableHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public List<String> listSchemaNames() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            List<String> list = this.delegate.listSchemaNames();
            return list;
        }
    }

    @Override
    public TableHandle getTableHandle(SchemaTableName tableName) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableHandle tableHandle = this.delegate.getTableHandle(tableName);
            return tableHandle;
        }
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(TableHandle table) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata(table);
            return connectorTableMetadata;
        }
    }

    @Override
    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            List<SchemaTableName> list = this.delegate.listTables(schemaNameOrNull);
            return list;
        }
    }

    @Override
    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getColumnHandle(tableHandle, columnName);
            return columnHandle;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Map<String, ColumnHandle> map = this.delegate.getColumnHandles(tableHandle);
            return map;
        }
    }

    @Override
    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Map<SchemaTableName, List<ColumnMetadata>> map = this.delegate.listTableColumns(prefix);
            return map;
        }
    }

    @Override
    public TableHandle createTable(ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableHandle tableHandle = this.delegate.createTable(tableMetadata);
            return tableHandle;
        }
    }

    @Override
    public void dropTable(TableHandle tableHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropTable(tableHandle);
        }
    }

    public String toString() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

