/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SerializableNativeValue {
    private final Class<?> type;
    private final Comparable<?> value;

    public SerializableNativeValue(Class<?> type, Comparable<?> value) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = value;
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(String.format("type %s does not match value %s", type.getClass(), value));
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Comparable<?> getValue() {
        return this.value;
    }

    public static class Deserializer
    extends JsonDeserializer<SerializableNativeValue> {
        public SerializableNativeValue deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Deserializer.checkJson(jsonParser.nextFieldName((SerializableString)new SerializedString("type")));
            String typeString = jsonParser.nextTextValue();
            Class<?> type = Deserializer.extractClassType(typeString);
            ColumnType.fromNativeType(type);
            Deserializer.checkJson(jsonParser.nextFieldName((SerializableString)new SerializedString("value")));
            JsonToken token = jsonParser.nextToken();
            Comparable<?> value = token == JsonToken.VALUE_NULL ? null : Deserializer.readValue(type, jsonParser);
            Deserializer.checkJson(jsonParser.nextToken() == JsonToken.END_OBJECT);
            return new SerializableNativeValue(type, value);
        }

        private static Comparable<?> readValue(Class<?> type, JsonParser jsonParser) throws IOException {
            ColumnType columnType = ColumnType.fromNativeType(type);
            switch (columnType) {
                case STRING: {
                    String value = jsonParser.getValueAsString();
                    Deserializer.checkJson(value != null);
                    return value;
                }
                case BOOLEAN: {
                    return jsonParser.getBooleanValue();
                }
                case LONG: {
                    return jsonParser.getLongValue();
                }
                case DOUBLE: {
                    return jsonParser.getDoubleValue();
                }
            }
            throw new AssertionError((Object)("Unknown type: " + (Object)((Object)columnType)));
        }

        private static void checkJson(boolean condition) {
            if (!condition) {
                throw new IllegalArgumentException("Malformed SerializableNativeValue JSON object");
            }
        }

        private static Class<?> extractClassType(String typeString) {
            try {
                return Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown class type: " + typeString);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<SerializableNativeValue> {
        public void serialize(SerializableNativeValue value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", value.getType().getCanonicalName());
            generator.writeFieldName("value");
            if (value.getValue() == null) {
                generator.writeNull();
            } else {
                Serializer.writeValue(value, generator);
            }
            generator.writeEndObject();
        }

        private static void writeValue(SerializableNativeValue value, JsonGenerator jsonGenerator) throws IOException {
            ColumnType columnType = ColumnType.fromNativeType(value.getType());
            switch (columnType) {
                case STRING: {
                    jsonGenerator.writeString((String)((Object)value.getValue()));
                    break;
                }
                case BOOLEAN: {
                    jsonGenerator.writeBoolean(((Boolean)value.getValue()).booleanValue());
                    break;
                }
                case LONG: {
                    jsonGenerator.writeNumber(((Long)value.getValue()).longValue());
                    break;
                }
                case DOUBLE: {
                    jsonGenerator.writeNumber(((Double)value.getValue()).doubleValue());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)columnType)));
                }
            }
        }
    }
}

