/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Map;

public final class ClassLoaderSafeConnectorSplitManager
implements ConnectorSplitManager {
    private final ConnectorSplitManager delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorSplitManager(ConnectorSplitManager delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    @Override
    public String getConnectorId() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getConnectorId();
            return string;
        }
    }

    @Override
    public boolean canHandle(TableHandle handle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(handle);
            return bl;
        }
    }

    @Override
    public List<Partition> getPartitions(TableHandle table, Map<ColumnHandle, Object> bindings) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            List<Partition> list = this.delegate.getPartitions(table, bindings);
            return list;
        }
    }

    @Override
    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Iterable<Split> iterable = this.delegate.getPartitionSplits(table, partitions);
            return iterable;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

