/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;

public class ClassLoaderSafeConnectorHandleResolver
implements ConnectorHandleResolver {
    private final ConnectorHandleResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorHandleResolver(ConnectorHandleResolver delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    @Override
    public boolean canHandle(TableHandle tableHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ColumnHandle columnHandle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(columnHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(Split split) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(split);
            return bl;
        }
    }

    @Override
    public Class<? extends TableHandle> getTableHandleClass() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends TableHandle> clazz = this.delegate.getTableHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends ColumnHandle> getColumnHandleClass() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ColumnHandle> clazz = this.delegate.getColumnHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends Split> getSplitClass() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends Split> clazz = this.delegate.getSplitClass();
            return clazz;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

