/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final List<ColumnMetadata> columns;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        if (table == null) {
            throw new NullPointerException("table is null or empty");
        }
        if (columns == null) {
            throw new NullPointerException("columns is null");
        }
        this.table = table;
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnMetadata>(columns));
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SchemaTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append('}');
        return sb.toString();
    }
}

