/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TestingColumnHandle;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleDomain {
    private static final ColumnHandle A = new TestingColumnHandle("a");
    private static final ColumnHandle B = new TestingColumnHandle("b");
    private static final ColumnHandle C = new TestingColumnHandle("c");
    private static final ColumnHandle D = new TestingColumnHandle("d");
    private static final ColumnHandle E = new TestingColumnHandle("e");
    private static final ColumnHandle F = new TestingColumnHandle("f");

    @Test
    public void testNone() {
        Assert.assertTrue((boolean)TupleDomain.none().isNone());
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
    }

    @Test
    public void testAll() {
        Assert.assertTrue((boolean)TupleDomain.all().isAll());
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of()));
    }

    @Test
    public void testIntersection() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true)).build());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)10.0), (Range[])new Range[0]), (boolean)false)).build());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)10.0, (boolean)false), (Range[])new Range[0]), (boolean)false)).build());
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneIntersection() {
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.all()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.all().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull((Type)BigintType.BIGINT))).intersect(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull((Type)BigintType.BIGINT)))), (Object)TupleDomain.none());
    }

    @Test
    public void testMismatchedColumnIntersection() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
    }

    @Test
    public void testColumnWiseUnion() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.onlyNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true)).build());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.notNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)10.0), (Range[])new Range[0]), (boolean)false)).build());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.all((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.all((Type)DoubleType.DOUBLE)).build());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneColumnWiseUnion() {
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.all(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull((Type)BigintType.BIGINT))), (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull((Type)BigintType.BIGINT))), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
    }

    @Test
    public void testMismatchedColumnWiseUnion() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE)));
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        Assert.assertFalse((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        Assert.assertTrue((boolean)this.overlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)C, (Object)Domain.none((Type)DoubleType.DOUBLE)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)DoubleType.DOUBLE)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)C, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)C, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)C, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0))));
    }

    @Test
    public void testIsNone() {
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.none((Type)BigintType.BIGINT))).isNone());
    }

    @Test
    public void testIsAll() {
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isAll());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)BigintType.BIGINT))).isAll());
    }

    @Test
    public void testExtractFixedValues() {
        Assert.assertEquals((Map)((Map)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE)).put((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)Domain.onlyNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true)).build())).get()), (Map)ImmutableMap.of((Object)B, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)NullableValue.asNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testExtractFixedValuesFromNone() {
        Assert.assertFalse((boolean)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.none()).isPresent());
    }

    @Test
    public void testExtractFixedValuesFromAll() {
        Assert.assertEquals((Map)((Map)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.all()).get()), (Map)ImmutableMap.of());
    }

    @Test
    public void testSingleValuesMapToDomain() {
        Assert.assertEquals((Object)TupleDomain.fromFixedValues((Map)ImmutableMap.builder().put((Object)A, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)1L)).put((Object)B, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.01)).put((Object)D, (Object)NullableValue.asNull((Type)BooleanType.BOOLEAN)).build()), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.01)).put((Object)D, (Object)Domain.onlyNull((Type)BooleanType.BOOLEAN)).build()));
    }

    @Test
    public void testEmptySingleValuesMapToDomain() {
        Assert.assertEquals((Object)TupleDomain.fromFixedValues((Map)ImmutableMap.of()), (Object)TupleDomain.all());
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        ObjectMapper mapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(ColumnHandle.class, (JsonDeserializer)new JsonDeserializer<ColumnHandle>(){

            public ColumnHandle deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return (ColumnHandle)new JsonObjectMapperProvider().get().readValue(jsonParser, TestingColumnHandle.class);
            }
        }).addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde)));
        TupleDomain tupleDomain = TupleDomain.all();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
        tupleDomain = TupleDomain.none();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
        tupleDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)A, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR)));
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
    }

    @Test
    public void testTransform() {
        ImmutableMap domains = ImmutableMap.builder().put((Object)1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)3, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).build();
        TupleDomain domain = TupleDomain.withColumnDomains((Map)domains);
        TupleDomain transformed = domain.transform(Object::toString);
        ImmutableMap expected = ImmutableMap.builder().put((Object)"1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)"2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)"3", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).build();
        Assert.assertEquals((Map)((Map)transformed.getDomains().get()), (Map)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testTransformFailsWithNonUniqueMapping() {
        ImmutableMap domains = ImmutableMap.builder().put((Object)1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)3, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).build();
        TupleDomain domain = TupleDomain.withColumnDomains((Map)domains);
        domain.transform(input -> "x");
    }

    private boolean overlaps(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDOmain2 = TupleDomain.withColumnDomains(domains2);
        return tupleDomain1.overlaps(tupleDOmain2);
    }

    private boolean contains(Map<ColumnHandle, Domain> superSet, Map<ColumnHandle, Domain> subSet) {
        TupleDomain superSetTupleDomain = TupleDomain.withColumnDomains(superSet);
        TupleDomain subSetTupleDomain = TupleDomain.withColumnDomains(subSet);
        return superSetTupleDomain.contains(subSetTupleDomain);
    }

    private boolean equals(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDOmain2 = TupleDomain.withColumnDomains(domains2);
        return tupleDomain1.equals((Object)tupleDOmain2);
    }
}

