/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.resourceGroups;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResourceGroupId {
    @Test
    public void testBasic() {
        new ResourceGroupId("test_test");
        new ResourceGroupId("test.test");
        new ResourceGroupId(new ResourceGroupId("test"), "test");
    }

    @Test
    public void testCodec() {
        JsonCodec codec = JsonCodec.jsonCodec(ResourceGroupId.class);
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("test.test"), "foo");
        Assert.assertEquals((Object)codec.fromJson(codec.toJson((Object)resourceGroupId)), (Object)resourceGroupId);
        Assert.assertEquals((String)codec.toJson((Object)resourceGroupId), (String)"[ \"test.test\", \"foo\" ]");
        Assert.assertEquals((Object)codec.fromJson("[\"test.test\", \"foo\"]"), (Object)resourceGroupId);
    }

    @Test
    public void testIsAncestor() {
        ResourceGroupId root = new ResourceGroupId("root");
        ResourceGroupId rootA = new ResourceGroupId(root, "a");
        ResourceGroupId rootAFoo = new ResourceGroupId(rootA, "foo");
        ResourceGroupId rootBar = new ResourceGroupId(root, "bar");
        Assert.assertTrue((boolean)root.isAncestorOf(rootA));
        Assert.assertTrue((boolean)root.isAncestorOf(rootAFoo));
        Assert.assertTrue((boolean)root.isAncestorOf(rootBar));
        Assert.assertTrue((boolean)rootA.isAncestorOf(rootAFoo));
        Assert.assertFalse((boolean)rootA.isAncestorOf(rootBar));
        Assert.assertFalse((boolean)rootAFoo.isAncestorOf(rootBar));
        Assert.assertFalse((boolean)rootBar.isAncestorOf(rootAFoo));
        Assert.assertFalse((boolean)rootAFoo.isAncestorOf(root));
        Assert.assertFalse((boolean)root.isAncestorOf(root));
        Assert.assertFalse((boolean)rootAFoo.isAncestorOf(rootAFoo));
    }
}

