/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.security.SelectedRole;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSelectedRole {
    private static final JsonCodec<SelectedRole> SELECTED_ROLE_JSON_CODEC = JsonCodec.jsonCodec(SelectedRole.class);

    @Test
    public void testJsonSerialization() throws Exception {
        TestSelectedRole.assertJsonRoundTrip(new SelectedRole(SelectedRole.Type.ALL, Optional.empty()));
        TestSelectedRole.assertJsonRoundTrip(new SelectedRole(SelectedRole.Type.NONE, Optional.empty()));
        TestSelectedRole.assertJsonRoundTrip(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role")));
    }

    private static void assertJsonRoundTrip(SelectedRole expected) {
        Assert.assertEquals((Object)SELECTED_ROLE_JSON_CODEC.fromJson(SELECTED_ROLE_JSON_CODEC.toJson((Object)expected)), (Object)expected);
    }

    @Test
    public void testToStringSerialization() throws Exception {
        TestSelectedRole.assertToStringRoundTrip(new SelectedRole(SelectedRole.Type.ALL, Optional.empty()));
        TestSelectedRole.assertToStringRoundTrip(new SelectedRole(SelectedRole.Type.NONE, Optional.empty()));
        TestSelectedRole.assertToStringRoundTrip(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role")));
    }

    private static void assertToStringRoundTrip(SelectedRole expected) {
        Assert.assertEquals((Object)SelectedRole.valueOf((String)expected.toString()), (Object)expected);
    }
}

