/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.page;

import com.facebook.presto.spi.page.PageCodecMarker;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageCodecMarker {
    @Test
    public void testCompressionAndEncryptionMarkers() {
        byte compressed = PageCodecMarker.COMPRESSED.set(PageCodecMarker.none());
        byte encrypted = PageCodecMarker.ENCRYPTED.set(PageCodecMarker.none());
        byte compressedAndEncrypted = PageCodecMarker.ENCRYPTED.set(PageCodecMarker.COMPRESSED.set(PageCodecMarker.none()));
        Assert.assertFalse((boolean)PageCodecMarker.COMPRESSED.isSet(PageCodecMarker.none()));
        Assert.assertFalse((boolean)PageCodecMarker.ENCRYPTED.isSet(PageCodecMarker.none()));
        Assert.assertTrue((boolean)PageCodecMarker.COMPRESSED.isSet(compressed));
        Assert.assertTrue((boolean)PageCodecMarker.COMPRESSED.isSet(compressedAndEncrypted));
        Assert.assertTrue((boolean)PageCodecMarker.ENCRYPTED.isSet(encrypted));
        Assert.assertTrue((boolean)PageCodecMarker.ENCRYPTED.isSet(compressedAndEncrypted));
        Assert.assertEquals((byte)PageCodecMarker.COMPRESSED.unset(compressed), (byte)PageCodecMarker.none());
        Assert.assertEquals((byte)PageCodecMarker.ENCRYPTED.unset(encrypted), (byte)PageCodecMarker.none());
        Assert.assertFalse((boolean)PageCodecMarker.COMPRESSED.isSet(PageCodecMarker.COMPRESSED.unset(compressedAndEncrypted)));
        Assert.assertFalse((boolean)PageCodecMarker.ENCRYPTED.isSet(PageCodecMarker.ENCRYPTED.unset(compressedAndEncrypted)));
        Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)PageCodecMarker.none()), (String)"NONE");
        Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)encrypted), (String)"ENCRYPTED");
        Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)compressed), (String)"COMPRESSED");
        Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)compressedAndEncrypted), (String)"COMPRESSED, ENCRYPTED");
    }

    @Test
    public void testIsSet() {
        Assert.assertEquals((byte)0, (byte)PageCodecMarker.none());
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assert.assertFalse((boolean)marker.isSet(PageCodecMarker.none()));
            Assert.assertTrue((boolean)marker.isSet(marker.set(PageCodecMarker.none())));
            Assert.assertFalse((boolean)marker.isSet(marker.unset(marker.set(PageCodecMarker.none()))));
            for (PageCodecMarker other : PageCodecMarker.values()) {
                Assert.assertEquals((other == marker ? 1 : 0) != 0, (boolean)other.isSet(marker.set(PageCodecMarker.none())));
            }
        }
    }

    @Test
    public void testSummaryString() {
        byte allMarkers = PageCodecMarker.none();
        Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)PageCodecMarker.none()), (String)"NONE");
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assert.assertEquals((String)PageCodecMarker.toSummaryString((byte)marker.set(PageCodecMarker.none())), (String)marker.name());
            allMarkers = marker.set(allMarkers);
        }
        String allMarkersSummary = PageCodecMarker.toSummaryString((byte)allMarkers);
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assert.assertTrue((boolean)allMarkersSummary.contains(marker.name()));
        }
    }
}

