/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LambdaDefinitionExpression
extends RowExpression {
    private final List<Type> argumentTypes;
    private final List<String> arguments;
    private final RowExpression body;

    @JsonCreator
    public LambdaDefinitionExpression(@JsonProperty(value="argumentTypes") List<Type> argumentTypes, @JsonProperty(value="arguments") List<String> arguments, @JsonProperty(value="body") RowExpression body) {
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
        this.arguments = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(arguments, "arguments is null")));
        LambdaDefinitionExpression.checkArgument(argumentTypes.size() == arguments.size(), "Number of argument types does not match number of arguments", new Object[0]);
        this.body = Objects.requireNonNull(body, "body is null");
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public RowExpression getBody() {
        return this.body;
    }

    @Override
    public Type getType() {
        return new FunctionType(this.argumentTypes, this.body.getType());
    }

    @Override
    public String toString() {
        return "(" + String.join((CharSequence)",", this.arguments) + ") -> " + this.body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDefinitionExpression that = (LambdaDefinitionExpression)o;
        return Objects.equals(this.argumentTypes, that.argumentTypes) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argumentTypes, this.arguments, this.body);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambda(this, context);
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

