/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.ByteArrayBlockBuilder;
import com.facebook.presto.spi.block.UncheckedBlock;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TypeSignature;

public final class BooleanType
extends AbstractType
implements FixedWidthType {
    public static final BooleanType BOOLEAN = new BooleanType();

    private BooleanType() {
        super(TypeSignature.parseTypeSignature("boolean"), Boolean.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getByte(position) != 0;
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftValue = leftBlock.getByte(leftPosition) != 0;
        boolean rightValue = rightBlock.getByte(rightPosition) != 0;
        return leftValue == rightValue;
    }

    @Override
    public long hash(Block block, int position) {
        boolean value = block.getByte(position) != 0;
        return value ? 1231L : 1237L;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftValue = leftBlock.getByte(leftPosition) != 0;
        boolean rightValue = rightBlock.getByte(rightPosition) != 0;
        return Boolean.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeByte(block.getByte(position)).closeEntry();
        }
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        return block.getByte(position) != 0;
    }

    @Override
    public boolean getBooleanUnchecked(UncheckedBlock block, int internalPosition) {
        return block.getByteUnchecked(internalPosition) != 0;
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        blockBuilder.writeByte(value ? 1 : 0).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == BOOLEAN;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

