/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import java.security.Principal;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface SystemAccessControl {
    public void checkCanSetUser(Optional<Principal> var1, String var2);

    public void checkCanSetSystemSessionProperty(Identity var1, String var2);

    default public void checkCanAccessCatalog(Identity identity, String catalogName) {
        AccessDeniedException.denyCatalogAccess(catalogName);
    }

    default public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return Collections.emptySet();
    }

    default public void checkCanCreateSchema(Identity identity, CatalogSchemaName schema) {
        AccessDeniedException.denyCreateSchema(schema.toString());
    }

    default public void checkCanDropSchema(Identity identity, CatalogSchemaName schema) {
        AccessDeniedException.denyDropSchema(schema.toString());
    }

    default public void checkCanRenameSchema(Identity identity, CatalogSchemaName schema, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schema.toString(), newSchemaName);
    }

    default public void checkCanShowSchemas(Identity identity, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(Identity identity, String catalogName, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyCreateTable(table.toString());
    }

    default public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropTable(table.toString());
    }

    default public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        AccessDeniedException.denyRenameTable(table.toString(), newTable.toString());
    }

    default public void checkCanShowTablesMetadata(Identity identity, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTablesMetadata(schema.toString());
    }

    default public Set<SchemaTableName> filterTables(Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyAddColumn(table.toString());
    }

    default public void checkCanDropColumn(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropColumn(table.toString());
    }

    default public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyRenameColumn(table.toString());
    }

    default public void checkCanSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denySelectColumns(table.toString(), columns);
    }

    default public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyInsertTable(table.toString());
    }

    default public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
        AccessDeniedException.denyDeleteTable(table.toString());
    }

    default public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateView(view.toString());
    }

    default public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
        AccessDeniedException.denyDropView(view.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denyCreateViewWithSelect(table.toString(), identity);
    }

    default public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), table.toString());
    }
}

