/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class FullyQualifiedName {
    private final List<String> parts;
    private final List<String> originalParts;

    @JsonCreator
    public static FullyQualifiedName of(String dottedName) {
        String[] parts = dottedName.split("\\.");
        if (parts.length < 3) {
            throw new IllegalArgumentException("FullyQualifiedName should be in the form of 'a.b.c' and have at least 3 parts");
        }
        return FullyQualifiedName.of(Arrays.asList(parts));
    }

    public static FullyQualifiedName of(String part1, String part2, String part3, String ... rest) {
        ArrayList<String> parts = new ArrayList<String>(rest.length + 3);
        parts.add(part1);
        parts.add(part2);
        parts.add(part3);
        parts.addAll(Arrays.asList(rest));
        return FullyQualifiedName.of(parts);
    }

    public static FullyQualifiedName of(List<String> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        if (originalParts.size() < 3) {
            throw new IllegalArgumentException("originalParts should have at least 3 parts");
        }
        ArrayList<String> parts = new ArrayList<String>(originalParts.size());
        for (String originalPart : originalParts) {
            parts.add(originalPart.toLowerCase(Locale.ENGLISH));
        }
        return new FullyQualifiedName(originalParts, parts);
    }

    public static FullyQualifiedName of(Prefix prefix, String name) {
        ArrayList<String> parts = new ArrayList<String>(prefix.parts);
        parts.add(name);
        return FullyQualifiedName.of(parts);
    }

    private FullyQualifiedName(List<String> originalParts, List<String> parts) {
        this.originalParts = Collections.unmodifiableList(originalParts);
        this.parts = Collections.unmodifiableList(parts);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<String> getOriginalParts() {
        return this.originalParts;
    }

    public String getSuffix() {
        return this.parts.get(this.parts.size() - 1);
    }

    public Prefix getPrefix() {
        return new Prefix(this.parts.subList(0, this.parts.size() - 1));
    }

    @JsonValue
    public String toString() {
        return String.join((CharSequence)".", this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((FullyQualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public static class Prefix {
        private final List<String> parts;

        private Prefix(List<String> parts) {
            this.parts = Collections.unmodifiableList(parts);
        }

        public static Prefix of(String dottedName) {
            String[] parts = dottedName.split("\\.");
            if (parts.length < 2) {
                throw new IllegalArgumentException("Prefix should be in the form of a.b(.c...) with at least 1 dot");
            }
            return new Prefix(Arrays.asList(parts));
        }

        public boolean contains(Prefix other) {
            if (this.parts.size() > other.parts.size()) {
                return false;
            }
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.get(i).equals(other.parts.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return String.join((CharSequence)".", this.parts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.parts.equals(((Prefix)o).parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }
}

