/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Objects;
import java.util.Optional;

public interface DomainTranslator {
    public static final ColumnExtractor<VariableReferenceExpression> BASIC_COLUMN_EXTRACTOR = (expression, domain) -> {
        if (expression instanceof VariableReferenceExpression) {
            return Optional.of((VariableReferenceExpression)expression);
        }
        return Optional.empty();
    };

    public RowExpression toPredicate(TupleDomain<VariableReferenceExpression> var1);

    public <T> ExtractionResult<T> fromPredicate(ConnectorSession var1, RowExpression var2, ColumnExtractor<T> var3);

    public static class ExtractionResult<T> {
        private final TupleDomain<T> tupleDomain;
        private final RowExpression remainingExpression;

        public ExtractionResult(TupleDomain<T> tupleDomain, RowExpression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<T> getTupleDomain() {
            return this.tupleDomain;
        }

        public RowExpression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    public static interface ColumnExtractor<T> {
        public Optional<T> extract(RowExpression var1, Domain var2);
    }
}

