/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Assignments assignments;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Assignments assignments) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(assignments, "assignments is null");
        this.source = source;
        this.assignments = assignments;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.assignments.getOutputs();
    }

    @JsonProperty
    public Assignments getAssignments() {
        return this.assignments;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Objects.requireNonNull(newChildren, "newChildren list is null");
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("newChildren list has multiple items");
        }
        return new ProjectNode(this.getId(), newChildren.get(0), this.assignments);
    }
}

