/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector.classloader;

import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ClassLoaderSafeConnectorPageSink
implements ConnectorPageSink {
    private final ConnectorPageSink delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSink(ConnectorPageSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public long getCompletedBytes() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getCompletedBytes();
            return l;
        }
    }

    @Override
    public long getSystemMemoryUsage() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getSystemMemoryUsage();
            return l;
        }
    }

    @Override
    public long getValidationCpuNanos() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getValidationCpuNanos();
            return l;
        }
    }

    @Override
    public CompletableFuture<?> appendPage(Page page) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture<?> completableFuture = this.delegate.appendPage(page);
            return completableFuture;
        }
    }

    @Override
    public CompletableFuture<Collection<Slice>> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture<Collection<Slice>> completableFuture = this.delegate.finish();
            return completableFuture;
        }
    }

    @Override
    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

