/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface ConnectorAccessControl {
    default public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        AccessDeniedException.denyCreateSchema(schemaName);
    }

    default public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        AccessDeniedException.denyDropSchema(schemaName);
    }

    default public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schemaName, newSchemaName);
    }

    default public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyCreateTable(tableName.toString());
    }

    default public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable(tableName.toString());
    }

    default public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable(tableName.toString(), newTableName.toString());
    }

    default public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        AccessDeniedException.denyShowTablesMetadata(schemaName);
    }

    default public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn(tableName.toString());
    }

    default public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropColumn(tableName.toString());
    }

    default public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn(tableName.toString());
    }

    default public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denySelectColumns(tableName.toString(), columnNames);
    }

    default public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable(tableName.toString());
    }

    default public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable(tableName.toString());
    }

    default public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView(viewName.toString());
    }

    default public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        AccessDeniedException.denyDropView(viewName.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect(tableName.toString(), identity);
    }

    default public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, Optional<PrestoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole(role);
    }

    default public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role) {
        AccessDeniedException.denyDropRole(role);
    }

    default public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    default public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    default public void checkCanSetRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, String catalogName) {
        AccessDeniedException.denySetRole(role);
    }

    default public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        AccessDeniedException.denyShowRoles(catalogName);
    }

    default public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        AccessDeniedException.denyShowCurrentRoles(catalogName);
    }

    default public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        AccessDeniedException.denyShowRoleGrants(catalogName);
    }
}

