/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public interface ConnectorSplitSource
extends Closeable {
    public CompletableFuture<ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle var1, int var2);

    default public void rewind(ConnectorPartitionHandle partitionHandle) {
        throw new UnsupportedOperationException("rewind is not supported in this ConnectorSplitSource");
    }

    @Override
    public void close();

    public boolean isFinished();

    public static class ConnectorSplitBatch {
        private final List<ConnectorSplit> splits;
        private final boolean noMoreSplits;

        public ConnectorSplitBatch(List<ConnectorSplit> splits, boolean noMoreSplits) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.noMoreSplits = noMoreSplits;
        }

        public List<ConnectorSplit> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }
}

