/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractFixedWidthType;
import com.facebook.presto.spi.type.TypeSignature;

public class TestingIdType
extends AbstractFixedWidthType {
    public static final TestingIdType ID = new TestingIdType();
    public static final String NAME = "id";

    private TestingIdType() {
        super(TypeSignature.parseTypeSignature((String)NAME), Long.TYPE, 8);
    }

    public boolean isComparable() {
        return true;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getLong(position, 0);
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
    }

    public long hash(Block block, int position) {
        return block.getLong(position, 0);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    public long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }
}

