/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowType {
    @Test
    public void testRowDisplayName() {
        List<RowType.Field> fields = Arrays.asList(RowType.field((String)"bool_col", (Type)BooleanType.BOOLEAN), RowType.field((String)"double_col", (Type)DoubleType.DOUBLE), RowType.field((String)"array_col", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"map_col", (Type)new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]))));
        RowType row = RowType.from(fields);
        Assert.assertEquals((String)row.getDisplayName(), (String)"row(bool_col boolean, double_col double, array_col array(varchar), map_col map(boolean, double))");
    }

    @Test
    public void testRowDisplayNoColumnNames() {
        List<Type> types = Arrays.asList(BooleanType.BOOLEAN, DoubleType.DOUBLE, new ArrayType((Type)VarcharType.VARCHAR), new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0])));
        RowType row = RowType.anonymous(types);
        Assert.assertEquals((String)row.getDisplayName(), (String)"row(boolean, double, array(varchar), map(boolean, double))");
    }

    @Test
    public void testRowDisplayMixedUnnamedColumns() {
        List<RowType.Field> fields = Arrays.asList(RowType.field((Type)BooleanType.BOOLEAN), RowType.field((String)"double_col", (Type)DoubleType.DOUBLE), RowType.field((Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"map_col", (Type)new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestRowType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]))));
        RowType row = RowType.from(fields);
        Assert.assertEquals((String)row.getDisplayName(), (String)"row(boolean, double_col double, array(varchar), map_col map(boolean, double))");
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

