/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.TestingBlockEncodingSerde;
import com.facebook.presto.spi.block.TestingBlockJsonSerde;
import com.facebook.presto.spi.predicate.EquatableValueSet;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.TestingIdType;
import com.facebook.presto.spi.type.TestingTypeDeserializer;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEquatableValueSet {
    @Test
    public void testEmptySet() {
        EquatableValueSet equatables = EquatableValueSet.none((Type)TestingIdType.ID);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertEquals((int)equatables.getValues().size(), (int)0);
        Assert.assertEquals((Object)equatables.complement(), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1L));
    }

    @Test
    public void testEntireSet() {
        EquatableValueSet equatables = EquatableValueSet.all((Type)TestingIdType.ID);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertTrue((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertFalse((boolean)equatables.isWhiteList());
        Assert.assertEquals((int)equatables.getValues().size(), (int)0);
        Assert.assertEquals((Object)equatables.complement(), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertTrue((boolean)equatables.containsValue((Object)0L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1L));
    }

    @Test
    public void testSingleValue() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)10L, (Object[])new Object[0]);
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertTrue((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)10L)));
        Assert.assertEquals((Object)equatables.complement(), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)10L));
        Assert.assertEquals((Object)complement.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.isWhiteList());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)10L)));
        Assert.assertEquals((Object)complement.complement(), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0L));
        Assert.assertTrue((boolean)complement.containsValue((Object)1L));
        Assert.assertFalse((boolean)complement.containsValue((Object)10L));
    }

    @Test
    public void testMultipleValues() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L, 3L, 1L});
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        Assert.assertEquals((Object)equatables.complement(), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)2L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)3L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)4L));
        Assert.assertEquals((Object)complement.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.isWhiteList());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        Assert.assertEquals((Object)complement.complement(), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0L));
        Assert.assertFalse((boolean)complement.containsValue((Object)1L));
        Assert.assertFalse((boolean)complement.containsValue((Object)2L));
        Assert.assertFalse((boolean)complement.containsValue((Object)3L));
        Assert.assertTrue((boolean)complement.containsValue((Object)4L));
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        try {
            EquatableValueSet.all((Type)TestingIdType.ID).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)2L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}).complement());
    }

    @Test
    public void testUnion() {
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableCollection() {
        EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues().clear();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableValueEntries() {
        EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries().clear();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues().iterator();
        iterator.next();
        iterator.remove();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableValueEntryIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries().iterator();
        iterator.next();
        iterator.remove();
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde((TypeManager)typeManager, new BlockEncoding[0]);
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        EquatableValueSet set = EquatableValueSet.all((Type)TestingIdType.ID);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.none((Type)TestingIdType.ID);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L});
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).complement();
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
    }
}

