/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import java.util.Locale;
import java.util.Optional;

public final class TestingSession {
    public static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Optional<String> getSource() {
            return Optional.of("TestSource");
        }

        public Identity getIdentity() {
            return new Identity("user", Optional.empty());
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public long getStartTime() {
            return 0L;
        }

        public Optional<String> getTraceToken() {
            return Optional.empty();
        }

        public boolean isLegacyTimestamp() {
            return true;
        }

        public boolean isLegacyRoundNBigint() {
            return false;
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
    };

    private TestingSession() {
    }
}

