/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.TestingBlockEncodingSerde;
import com.facebook.presto.spi.block.TestingSession;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockEncoding {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde((TypeManager)new TestingTypeManager(), new BlockEncoding[0]);

    @Test
    public void testRoundTrip() {
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, expectedBlock);
        Block actualBlock = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        TestVariableWidthBlockEncoding.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, expectedBlock);
    }

    private static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(TestingSession.SESSION, actual, position), (Object)type.getObjectValue(TestingSession.SESSION, expected, position));
        }
    }
}

