/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.block.PageBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixedWidthBlockBuilder {
    private static final int BOOLEAN_ENTRY_SIZE = BooleanType.BOOLEAN.getFixedSize() + 1;
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() {
        TestFixedWidthBlockBuilder.testIsFull(new PageBuilderStatus(BOOLEAN_ENTRY_SIZE * 3));
    }

    private static void testIsFull(PageBuilderStatus pageBuilderStatus) {
        FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(BooleanType.BOOLEAN.getFixedSize(), pageBuilderStatus.createBlockBuilderStatus(), 1024);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            BooleanType.BOOLEAN.writeBoolean((BlockBuilder)blockBuilder, true);
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)3);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }
}

