/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPage {
    @Test
    public void testGetRegion() {
        Assert.assertEquals((int)new Page(10, new Block[0]).getRegion(5, 5).getPositionCount(), (int)5);
    }

    @Test
    public void testGetEmptyRegion() {
        Assert.assertEquals((int)new Page(0, new Block[0]).getRegion(0, 0).getPositionCount(), (int)0);
        Assert.assertEquals((int)new Page(10, new Block[0]).getRegion(5, 0).getPositionCount(), (int)0);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class}, expectedExceptionsMessageRegExp="Invalid position 1 and length 1 in page with 0 positions")
    public void testGetRegionExceptions() {
        new Page(0, new Block[0]).getRegion(1, 1);
    }

    @Test
    public void testGetRegionFromNoColumnPage() {
        Assert.assertEquals((int)new Page(100, new Block[0]).getRegion(0, 10).getPositionCount(), (int)10);
    }

    @Test
    public void testCompactDictionaryBlocks() {
        int positionCount = 100;
        DictionaryId commonSourceId = DictionaryId.randomDictionaryId();
        int commonDictionaryUsedPositions = 20;
        int[] commonDictionaryIds = TestPage.getDictionaryIds(positionCount, commonDictionaryUsedPositions);
        Slice[] dictionaryValues1 = TestPage.createExpectedValues(50);
        Block dictionary1 = TestPage.createSlicesBlock(dictionaryValues1);
        DictionaryBlock commonSourceIdBlock1 = new DictionaryBlock(positionCount, dictionary1, commonDictionaryIds, commonSourceId);
        BlockBuilder dictionary2 = BigintType.BIGINT.createBlockBuilder(null, dictionary1.getPositionCount());
        for (Slice expectedValue : dictionaryValues1) {
            BigintType.BIGINT.writeLong(dictionary2, (long)expectedValue.length());
        }
        DictionaryBlock commonSourceIdBlock2 = new DictionaryBlock(positionCount, dictionary2.build(), commonDictionaryIds, commonSourceId);
        int otherDictionaryUsedPositions = 30;
        int[] otherDictionaryIds = TestPage.getDictionaryIds(positionCount, otherDictionaryUsedPositions);
        Block dictionary3 = TestPage.createSlicesBlock(TestPage.createExpectedValues(70));
        DictionaryBlock randomSourceIdBlock = new DictionaryBlock(dictionary3, otherDictionaryIds);
        Page page = new Page(new Block[]{commonSourceIdBlock1, randomSourceIdBlock, commonSourceIdBlock2});
        page.compact();
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(0)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(1)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(2)).isCompact());
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(0)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(1)).getDictionary().getPositionCount(), (int)otherDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(2)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertNotEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(1)).getDictionarySourceId());
        Assert.assertEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(2)).getDictionarySourceId());
    }

    @Test
    public void testGetPositions() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block}).getPositions(new int[]{0, 1, 1, 1, 2, 5, 5}, 1, 5);
        Assert.assertEquals((int)page.getPositionCount(), (int)5);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)page.getBlock(i).getLong(0, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(1, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(2, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(3, 0), (long)2L);
            Assert.assertEquals((long)page.getBlock(i).getLong(4, 0), (long)5L);
        }
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPage.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    private static int[] getDictionaryIds(int positionCount, int dictionarySize) {
        Preconditions.checkArgument((positionCount > dictionarySize ? 1 : 0) != 0);
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return ids;
    }

    private static Block createSlicesBlock(Slice[] values) {
        BlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 100);
        for (Slice value : values) {
            Verify.verify((value != null ? 1 : 0) != 0);
            VarbinaryType.VARBINARY.writeSlice(builder, value);
        }
        return builder.build();
    }
}

