/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class SqlTime {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private final long millisUtc;
    private final TimeZoneKey sessionTimeZoneKey;

    public SqlTime(long millisUtc, TimeZoneKey sessionTimeZoneKey) {
        this.millisUtc = millisUtc;
        this.sessionTimeZoneKey = sessionTimeZoneKey;
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.sessionTimeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTime other = (SqlTime)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        return Instant.ofEpochMilli(this.millisUtc).atZone(ZoneId.of(this.sessionTimeZoneKey.getId())).format(formatter);
    }
}

