/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class NamedTypeSignature {
    private final Optional<String> name;
    private final TypeSignature typeSignature;

    @JsonCreator
    public NamedTypeSignature(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="typeSignature") TypeSignature typeSignature) {
        this.name = name;
        this.typeSignature = typeSignature;
    }

    public NamedTypeSignature(String name, TypeSignature typeSignature) {
        this(Optional.of(name), typeSignature);
    }

    @JsonProperty
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedTypeSignature other = (NamedTypeSignature)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.typeSignature, other.typeSignature);
    }

    public String toString() {
        if (this.name.isPresent()) {
            return String.format("%s %s", this.name.get(), this.typeSignature);
        }
        return this.typeSignature.toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeSignature);
    }
}

