/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractMapBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import java.util.Objects;

public class ColumnarMap {
    private final Block nullCheckBlock;
    private final int offsetsOffset;
    private final int[] offsets;
    private final Block keysBlock;
    private final Block valuesBlock;

    public static ColumnarMap toColumnarMap(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarMap.toColumnarMap((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarMap.toColumnarMap((RunLengthEncodedBlock)block);
        }
        if (block instanceof LazyBlock) {
            LazyBlock lazyBlock = (LazyBlock)block;
            if (!lazyBlock.isLoaded()) {
                throw new IllegalArgumentException("LazyBlock is expected to be loaded");
            }
            return ColumnarMap.toColumnarMap(lazyBlock.getBlock());
        }
        if (!(block instanceof AbstractMapBlock)) {
            throw new IllegalArgumentException("Invalid map block: " + block.getClass().getName());
        }
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        int firstEntryPosition = mapBlock.getOffset(0);
        int totalEntryCount = mapBlock.getOffset(block.getPositionCount()) - firstEntryPosition;
        Block keysBlock = mapBlock.getRawKeyBlock().getRegion(firstEntryPosition, totalEntryCount);
        Block valuesBlock = mapBlock.getRawValueBlock().getRegion(firstEntryPosition, totalEntryCount);
        return new ColumnarMap(block, offsetBase, offsets, keysBlock, valuesBlock);
    }

    private static ColumnarMap toColumnarMap(DictionaryBlock dictionaryBlock) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap(dictionaryBlock.getDictionary());
        int[] offsets = new int[dictionaryBlock.getPositionCount() + 1];
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            offsets[position + 1] = offsets[position] + columnarMap.getEntryCount(dictionaryId);
        }
        int[] dictionaryIds = new int[offsets[dictionaryBlock.getPositionCount()]];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            int entryCount = columnarMap.getEntryCount(dictionaryId);
            int startOffset = columnarMap.getOffset(dictionaryId) - columnarMap.getOffset(0);
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                dictionaryIds[nextDictionaryIndex] = startOffset + entryIndex;
                ++nextDictionaryIndex;
            }
        }
        return new ColumnarMap(dictionaryBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, columnarMap.getKeysBlock(), dictionaryIds), new DictionaryBlock(dictionaryIds.length, columnarMap.getValuesBlock(), dictionaryIds));
    }

    private static ColumnarMap toColumnarMap(RunLengthEncodedBlock rleBlock) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap(rleBlock.getValue());
        int[] offsets = new int[rleBlock.getPositionCount() + 1];
        int entryCount = columnarMap.getEntryCount(0);
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i * entryCount;
        }
        int[] dictionaryIds = new int[rleBlock.getPositionCount() * entryCount];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < rleBlock.getPositionCount(); ++position) {
            int entryIndex = 0;
            while (entryIndex < entryCount) {
                dictionaryIds[nextDictionaryIndex] = entryIndex++;
                ++nextDictionaryIndex;
            }
        }
        return new ColumnarMap(rleBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, columnarMap.getKeysBlock(), dictionaryIds), new DictionaryBlock(dictionaryIds.length, columnarMap.getValuesBlock(), dictionaryIds));
    }

    private ColumnarMap(Block nullCheckBlock, int offsetsOffset, int[] offsets, Block keysBlock, Block valuesBlock) {
        this.nullCheckBlock = nullCheckBlock;
        this.offsetsOffset = offsetsOffset;
        this.offsets = offsets;
        this.keysBlock = keysBlock;
        this.valuesBlock = valuesBlock;
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getEntryCount(int position) {
        return this.offsets[position + 1 + this.offsetsOffset] - this.offsets[position + this.offsetsOffset];
    }

    private int getOffset(int position) {
        return this.offsets[position + this.offsetsOffset];
    }

    public Block getKeysBlock() {
        return this.keysBlock;
    }

    public Block getValuesBlock() {
        return this.valuesBlock;
    }
}

