/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTablePartitioning;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorTableLayout {
    private final ConnectorTableLayoutHandle handle;
    private final Optional<List<ColumnHandle>> columns;
    private final TupleDomain<ColumnHandle> predicate;
    private final Optional<ConnectorTablePartitioning> tablePartitioning;
    private final Optional<Set<ColumnHandle>> streamPartitioningColumns;
    private final Optional<DiscretePredicates> discretePredicates;
    private final List<LocalProperty<ColumnHandle>> localProperties;

    public ConnectorTableLayout(ConnectorTableLayoutHandle handle) {
        this(handle, Optional.empty(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    public ConnectorTableLayout(ConnectorTableLayoutHandle handle, Optional<List<ColumnHandle>> columns, TupleDomain<ColumnHandle> predicate, Optional<ConnectorTablePartitioning> tablePartitioning, Optional<Set<ColumnHandle>> streamPartitioningColumns, Optional<DiscretePredicates> discretePredicates, List<LocalProperty<ColumnHandle>> localProperties) {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(streamPartitioningColumns, "partitioningColumns is null");
        Objects.requireNonNull(tablePartitioning, "tablePartitioning is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(discretePredicates, "discretePredicates is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.handle = handle;
        this.columns = columns;
        this.tablePartitioning = tablePartitioning;
        this.streamPartitioningColumns = streamPartitioningColumns;
        this.predicate = predicate;
        this.discretePredicates = discretePredicates;
        this.localProperties = localProperties;
    }

    public ConnectorTableLayoutHandle getHandle() {
        return this.handle;
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.columns;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public Optional<ConnectorTablePartitioning> getTablePartitioning() {
        return this.tablePartitioning;
    }

    public Optional<Set<ColumnHandle>> getStreamPartitioningColumns() {
        return this.streamPartitioningColumns;
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.discretePredicates;
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.localProperties;
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.columns, this.predicate, this.discretePredicates, this.streamPartitioningColumns, this.tablePartitioning, this.localProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorTableLayout other = (ConnectorTableLayout)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.columns, other.columns) && Objects.equals(this.predicate, other.predicate) && Objects.equals(this.discretePredicates, other.discretePredicates) && Objects.equals(this.streamPartitioningColumns, other.streamPartitioningColumns) && Objects.equals(this.tablePartitioning, other.tablePartitioning) && Objects.equals(this.localProperties, other.localProperties);
    }
}

