/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaUtil;
import java.util.Objects;

public final class CatalogSchemaTableName {
    private final String catalogName;
    private final SchemaTableName schemaTableName;

    public CatalogSchemaTableName(String catalogName, SchemaTableName schemaTableName) {
        this.catalogName = SchemaUtil.checkNotEmpty(catalogName, "catalogName");
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
    }

    public CatalogSchemaTableName(String catalogName, String schemaName, String tableName) {
        this(catalogName, new SchemaTableName(schemaName, tableName));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSchemaTableName that = (CatalogSchemaTableName)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaTableName, that.schemaTableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaTableName);
    }

    public String toString() {
        return this.catalogName + '.' + this.schemaTableName.toString();
    }
}

