/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TestMapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowType {
    @Test
    public void testRowDisplayName() {
        List<Type> types = Arrays.asList(BooleanType.BOOLEAN, DoubleType.DOUBLE, new ArrayType((Type)VarcharType.VARCHAR), new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0])));
        Optional<List<String>> names = Optional.of(Arrays.asList("bool_col", "double_col", "array_col", "map_col"));
        RowType row = new RowType(types, names);
        Assert.assertEquals((String)row.getDisplayName(), (String)"row(bool_col boolean, double_col double, array_col array(varchar), map_col map(boolean, double))");
    }

    @Test
    public void testRowDisplayNoColumnNames() {
        List<Type> types = Arrays.asList(BooleanType.BOOLEAN, DoubleType.DOUBLE, new ArrayType((Type)VarcharType.VARCHAR), new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestMapType.class, (String)"throwUnsupportedOperation", (Class[])new Class[0])));
        RowType row = new RowType(types, Optional.empty());
        Assert.assertEquals((String)row.getDisplayName(), (String)"row(boolean, double, array(varchar), map(boolean, double))");
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

