/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.DecimalParseResult;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecimals {
    @Test
    public void testParse() throws Exception {
        this.assertParseResult("0", 0L, 1, 0);
        this.assertParseResult("+0", 0L, 1, 0);
        this.assertParseResult("-0", 0L, 1, 0);
        this.assertParseResult("000", 0L, 1, 0);
        this.assertParseResult("+000", 0L, 1, 0);
        this.assertParseResult("-000", 0L, 1, 0);
        this.assertParseResult("0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("+0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("-0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("1.1", 11L, 2, 1);
        this.assertParseResult("+1.1", 11L, 2, 1);
        this.assertParseResult("-1.1", -11L, 2, 1);
        this.assertParseResult("0001.1", 11L, 2, 1);
        this.assertParseResult("+0001.1", 11L, 2, 1);
        this.assertParseResult("-0001.1", -11L, 2, 1);
        this.assertParseResult("0.1", 1L, 1, 1);
        this.assertParseResult("+0.1", 1L, 1, 1);
        this.assertParseResult("-0.1", -1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult("000.1", 1L, 1, 1);
        this.assertParseResult("+000.1", 1L, 1, 1);
        this.assertParseResult("-000.1", -1L, 1, 1);
        this.assertParseResult("12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-12345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-00012345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-0.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-000.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-12345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-00012345678901234567890.123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult(".12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0000.12345678901234567890123456789012345678", TestDecimals.encodeUnscaledValue("-12345678901234567890123456789012345678"), 38, 38);
    }

    @Test
    public void testParseIncludeLeadingZerosInPrecision() throws Exception {
        this.assertParseResultIncludeLeadingZerosInPrecision("0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-0", 0L, 1, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-00000000000000000", 0L, 17, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("1.1", 11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+1.1", 11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-1.1", -11L, 2, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("0001.1", 11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+0001.1", 11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-0001.1", -11L, 5, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000", 0L, 3, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("000.1", 1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000.1", 1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000.1", -1L, 4, 1);
        this.assertParseResultIncludeLeadingZerosInPrecision("000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000000000000000000", 0L, 18, 0);
        this.assertParseResultIncludeLeadingZerosInPrecision("000000000000000000.123", TestDecimals.encodeUnscaledValue("123"), 21, 3);
        this.assertParseResultIncludeLeadingZerosInPrecision("+000000000000000000.123", TestDecimals.encodeUnscaledValue("123"), 21, 3);
        this.assertParseResultIncludeLeadingZerosInPrecision("-000000000000000000.123", TestDecimals.encodeUnscaledValue("-123"), 21, 3);
    }

    private void assertParseResult(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assert.assertEquals((Object)Decimals.parse((String)value), (Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private void assertParseResultIncludeLeadingZerosInPrecision(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assert.assertEquals((Object)Decimals.parseIncludeLeadingZerosInPrecision((String)value), (Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private static Slice encodeUnscaledValue(String unscaledValue) {
        return Decimals.encodeUnscaledValue((BigInteger)new BigInteger(unscaledValue));
    }
}

