/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.Chars;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestChars {
    @Test
    public void testTruncateToLengthAndTrimSpaces() {
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a  "), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"abc"), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)0));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)3));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)4));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)5));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)3));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)4));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)5));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"  "), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)""), (int)1));
    }

    @Test
    public void testByteCountWithoutTrailingSpaces() throws Exception {
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 0, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 3, "bc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 3, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 2, "bc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 6, "abc de");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 7, "bc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 7, "abc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 6, "bc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 1, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 3, "  d");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 4, "  de");
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 4, 9);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 12, 1);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", -1, 1);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 1, -1);
        TestChars.assertByteCountWithoutTrailingSpace("       ", 0, 4, "");
        TestChars.assertByteCountWithoutTrailingSpace("       ", 0, 0, "");
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 2, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 1, new byte[]{-127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 0, new byte[0]);
    }

    @Test
    public void testByteCountWithoutTrailingSpacesWithCodePointLimit() throws Exception {
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 0, 1, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 3, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, 3, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 5, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 3, 3, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 2, 3, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 0, 3, new byte[0]);
    }

    private static void assertByteCountWithoutTrailingSpaceFailure(String string, int offset, int maxLength) {
        try {
            Chars.byteCountWithoutTrailingSpace((Slice)Slices.utf8Slice((String)string), (int)offset, (int)maxLength);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertByteCountWithoutTrailingSpace(String actual, int offset, int length, String expected) {
        TestChars.assertByteCountWithoutTrailingSpace(Slices.utf8Slice((String)actual).getBytes(), offset, length, Slices.utf8Slice((String)expected).getBytes());
    }

    private static void assertByteCountWithoutTrailingSpace(byte[] actual, int offset, int length, byte[] expected) {
        Slice slice = Slices.wrappedBuffer((byte[])actual);
        int trimmedLength = Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length);
        byte[] bytes = slice.getBytes(offset, trimmedLength);
        Assert.assertEquals((Object)bytes, (Object)expected);
    }

    private static void assertByteCountWithoutTrailingSpace(String actual, int offset, int length, int codePointCount, String expected) {
        TestChars.assertByteCountWithoutTrailingSpace(Slices.utf8Slice((String)actual).getBytes(), offset, length, codePointCount, Slices.utf8Slice((String)expected).getBytes());
    }

    private static void assertByteCountWithoutTrailingSpace(byte[] actual, int offset, int length, int codePointCount, byte[] expected) {
        Slice slice = Slices.wrappedBuffer((byte[])actual);
        int truncatedLength = Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)codePointCount);
        byte[] bytes = slice.getBytes(offset, truncatedLength);
        Assert.assertEquals((Object)bytes, (Object)expected);
    }
}

