/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.TestingBlockEncodingSerde;
import com.facebook.presto.spi.block.TestingBlockJsonSerde;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.SortedRangeSet;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TestingTypeDeserializer;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortedRangeSet {
    @Test
    public void testEmptySet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.none((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)rangeSet.getOrderedRanges()));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)0);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testEntireSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertTrue((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testSingleValue() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)10L, (Object[])new Object[0]);
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertTrue((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)10L))));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)10L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testBoundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false), Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)false, (Object)5L, (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)5L, (boolean)true), (Object)Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)false, (Object)9L, (boolean)false), Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)11L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnboundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)false, (Object)11L, (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)9L));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)9L, (boolean)true)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)4L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        try {
            SortedRangeSet.all((Type)BigintType.BIGINT).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSpan() throws Exception {
        try {
            SortedRangeSet.none((Type)BigintType.BIGINT).getSpan();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSpan(), (Object)Range.equal((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)1L, (boolean)true));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)3L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)false, (Object)4L, (boolean)false)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)-1L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)-1L, (boolean)true, (Object)1L, (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testUnion() throws Exception {
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)3L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all((Type)BigintType.BIGINT), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
    }

    @Test
    public void testSubtract() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde((TypeManager)typeManager, new BlockEncodingFactory[0]);
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        SortedRangeSet set = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.none((Type)DoubleType.DOUBLE);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"), (Object[])new Object[0]);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[]{Range.equal((Type)BooleanType.BOOLEAN, (Object)false)});
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assert.assertEquals((Object)first.union((ValueSet)second), (Object)expected);
        Assert.assertEquals((Object)first.union((Collection)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }
}

