/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.ArrayBlockEncoding;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.ByteArrayBlockEncoding;
import com.facebook.presto.spi.block.DictionaryBlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.IntArrayBlockEncoding;
import com.facebook.presto.spi.block.LongArrayBlockEncoding;
import com.facebook.presto.spi.block.MapBlockEncoding;
import com.facebook.presto.spi.block.ShortArrayBlockEncoding;
import com.facebook.presto.spi.block.SingleMapBlockEncoding;
import com.facebook.presto.spi.block.SliceArrayBlockEncoding;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TestingBlockEncodingSerde
implements BlockEncodingSerde {
    private final TypeManager typeManager;
    private final ConcurrentMap<String, BlockEncodingFactory<?>> blockEncodings = new ConcurrentHashMap();

    public TestingBlockEncodingSerde(TypeManager typeManager, BlockEncodingFactory<?> ... blockEncodingFactories) {
        this(typeManager, (Set<BlockEncodingFactory<?>>)ImmutableSet.copyOf((Object[])blockEncodingFactories));
    }

    public TestingBlockEncodingSerde(TypeManager typeManager, Set<BlockEncodingFactory<?>> blockEncodingFactories) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.addBlockEncodingFactory(VariableWidthBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(FixedWidthBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(ByteArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(ShortArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(IntArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(LongArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(SliceArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(DictionaryBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(ArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(MapBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(SingleMapBlockEncoding.FACTORY);
        for (BlockEncodingFactory<?> factory : Objects.requireNonNull(blockEncodingFactories, "blockEncodingFactories is null")) {
            this.addBlockEncodingFactory(factory);
        }
    }

    public void addBlockEncodingFactory(BlockEncodingFactory<?> blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncodingFactory<?> existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding %s is already registered", (Object)blockEncoding.getName());
    }

    public BlockEncoding readBlockEncoding(SliceInput input) {
        String encodingName = TestingBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncodingFactory blockEncoding = (BlockEncodingFactory)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding %s", (Object)encodingName);
        return blockEncoding.readEncoding(this.typeManager, (BlockEncodingSerde)this, input);
    }

    public void writeBlockEncoding(SliceOutput output, BlockEncoding encoding) {
        String encodingName = encoding.getName();
        BlockEncodingFactory blockEncoding = encoding.getFactory();
        TestingBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeEncoding((BlockEncodingSerde)this, output, encoding);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

