/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.block.ColumnarTestUtils;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.MapBlockBuilder;
import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnarMap {
    private static final int[] MAP_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void test() throws Exception {
        Slice[][][] expectedValues = new Slice[MAP_SIZES.length][][];
        for (int mapIndex = 0; mapIndex < MAP_SIZES.length; ++mapIndex) {
            expectedValues[mapIndex] = new Slice[MAP_SIZES[mapIndex]][];
            for (int entryIndex = 0; entryIndex < MAP_SIZES[mapIndex]; ++entryIndex) {
                Slice[] entry = new Slice[2];
                entry[0] = Slices.utf8Slice((String)String.format("key.%d.%d", mapIndex, entryIndex));
                if (entryIndex % 3 != 1) {
                    entry[1] = Slices.utf8Slice((String)String.format("value.%d.%d", mapIndex, entryIndex));
                }
                expectedValues[mapIndex][entryIndex] = entry;
            }
        }
        BlockBuilder blockBuilder = TestColumnarMap.createBlockBuilderWithValues(expectedValues);
        TestColumnarMap.verifyBlock((Block)blockBuilder, expectedValues);
        TestColumnarMap.verifyBlock(blockBuilder.build(), expectedValues);
        Slice[][][] expectedValuesWithNull = (Slice[][][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestColumnarMap.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarMap.verifyBlock((Block)blockBuilderWithNull, expectedValuesWithNull);
        TestColumnarMap.verifyBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
    }

    private static void verifyBlock(Block block, Slice[][][] expectedValues) {
        ColumnarTestUtils.assertBlock(block, expectedValues);
        TestColumnarMap.assertColumnarMap(block, expectedValues);
        TestColumnarMap.assertDictionaryBlock(block, expectedValues);
        TestColumnarMap.assertRunLengthEncodedBlock(block, expectedValues);
    }

    private static void assertDictionaryBlock(Block block, Slice[][][] expectedValues) {
        DictionaryBlock dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertColumnarMap((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertRunLengthEncodedBlock((Block)dictionaryBlock, expectedDictionaryValues);
    }

    private static void assertRunLengthEncodedBlock(Block block, Slice[][][] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarMap.assertColumnarMap((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static void assertColumnarMap(Block block, Slice[][][] expectedValues) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Assert.assertEquals((int)columnarMap.getPositionCount(), (int)expectedValues.length);
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        int keysPosition = 0;
        int valuesPosition = 0;
        for (int position = 0; position < expectedValues.length; ++position) {
            Slice[][] expectedMap = expectedValues[position];
            Assert.assertEquals((boolean)columnarMap.isNull(position), (expectedMap == null ? 1 : 0) != 0);
            if (expectedMap == null) {
                Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)0);
                continue;
            }
            Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)expectedMap.length);
            for (int i = 0; i < columnarMap.getEntryCount(position); ++i) {
                Slice[] expectedEntry = expectedMap[i];
                Slice expectedKey = expectedEntry[0];
                ColumnarTestUtils.assertBlockPosition(keysBlock, keysPosition, expectedKey);
                ++keysPosition;
                Slice expectedValue = expectedEntry[1];
                ColumnarTestUtils.assertBlockPosition(valuesBlock, valuesPosition, expectedValue);
                ++valuesPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][][] expectedValues) {
        BlockBuilder blockBuilder = TestColumnarMap.createMapBuilder(new BlockBuilderStatus(), 100);
        for (Slice[][] expectedMap : expectedValues) {
            if (expectedMap == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), expectedMap.length);
            for (Slice[] entry : expectedMap) {
                Slice key = entry[0];
                Assert.assertNotNull((Object)key);
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, key);
                Slice value = entry[1];
                if (value == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, value);
            }
            blockBuilder.writeObject((Object)elementBlockBuilder.build()).closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createMapBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new MapBlockBuilder((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(Slice.class, (String)"equals", (Class[])new Class[]{Object.class}).asType(MethodType.methodType(Boolean.TYPE, Slice.class, Slice.class)), MethodHandleUtil.methodHandle(Slice.class, (String)"hashCode", (Class[])new Class[0]).asType(MethodType.methodType(Long.TYPE, Slice.class)), MethodHandleUtil.methodHandle(TestColumnarMap.class, (String)"blockVarcharHashCode", (Class[])new Class[]{Block.class, Integer.TYPE}), blockBuilderStatus, expectedEntries);
    }

    public static long blockVarcharHashCode(Block block, int position) {
        return block.hash(position, 0, block.getSliceLength(position));
    }
}

