/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.ArrayBlockBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.ByteArrayBlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.block.IntArrayBlockBuilder;
import com.facebook.presto.spi.block.LongArrayBlockBuilder;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.block.ShortArrayBlockBuilder;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockRetainedSizeBreakdown {
    private static final int EXPECTED_ENTRIES = 100;

    @Test
    public void testArrayBlock() {
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, new BlockBuilderStatus(), 100);
        for (int i = 0; i < 100; ++i) {
            BlockBuilder arrayElementBuilder = arrayBlockBuilder.beginBlockEntry();
            TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (BlockBuilder)arrayElementBuilder, (Object)TestBlockRetainedSizeBreakdown.castIntegerToObject(i, (Type)BigintType.BIGINT));
            arrayBlockBuilder.closeEntry();
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(arrayBlockBuilder.build(), false);
    }

    @Test
    public void testByteArrayBlock() {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(new BlockBuilderStatus(), 100);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.writeByte(i);
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testDictionaryBlock() {
        Block keyDictionaryBlock = TestBlockRetainedSizeBreakdown.createSliceArrayBlock(100);
        int[] keyIds = new int[100];
        for (int i = 0; i < keyIds.length; ++i) {
            keyIds[i] = i;
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize((Block)new DictionaryBlock(100, keyDictionaryBlock, keyIds), false);
    }

    @Test
    public void testFixedWidthBlock() {
        FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(8, new BlockBuilderStatus(), 100);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)DoubleType.DOUBLE);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), true);
    }

    @Test
    public void testIntArrayBlock() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(new BlockBuilderStatus(), 100);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)IntegerType.INTEGER);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testLongArrayBlock() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(new BlockBuilderStatus(), 100);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)BigintType.BIGINT);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testRunLengthEncodedBlock() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(new BlockBuilderStatus(), 1);
        TestBlockRetainedSizeBreakdown.writeEntries(1, (BlockBuilder)blockBuilder, (Type)BigintType.BIGINT);
        TestBlockRetainedSizeBreakdown.checkRetainedSize((Block)new RunLengthEncodedBlock(blockBuilder.build(), 1), false);
    }

    @Test
    public void testShortArrayBlock() {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(new BlockBuilderStatus(), 100);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.writeShort(i);
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testSliceArrayBlock() {
        TestBlockRetainedSizeBreakdown.checkRetainedSize(TestBlockRetainedSizeBreakdown.createSliceArrayBlock(100), true);
    }

    @Test
    public void testVariableWidthBlock() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus(), 100, 400);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)VarcharType.VARCHAR);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    private static void checkRetainedSize(Block block, boolean getRegionCreateNewObjects) {
        AtomicLong objectSize = new AtomicLong();
        Object2LongOpenCustomHashMap trackedObjects = new Object2LongOpenCustomHashMap((Hash.Strategy)new ObjectStrategy());
        BiConsumer<Object, Long> consumer = (object, size) -> {
            objectSize.addAndGet((long)size);
            trackedObjects.addTo(object, 1L);
        };
        block.retainedBytesForEachPart(consumer);
        Assert.assertEquals((long)objectSize.get(), (long)block.getRetainedSizeInBytes());
        Block copyBlock = block.getRegion(0, block.getPositionCount() / 2);
        copyBlock.retainedBytesForEachPart(consumer);
        Assert.assertEquals((long)objectSize.get(), (long)(block.getRetainedSizeInBytes() + copyBlock.getRetainedSizeInBytes()));
        Assert.assertEquals((long)trackedObjects.getLong((Object)block), (long)1L);
        Assert.assertEquals((long)trackedObjects.getLong((Object)copyBlock), (long)1L);
        trackedObjects.remove((Object)block);
        trackedObjects.remove((Object)copyBlock);
        LongIterator longIterator = trackedObjects.values().iterator();
        while (longIterator.hasNext()) {
            long value = (Long)longIterator.next();
            Assert.assertEquals((long)value, (long)(getRegionCreateNewObjects ? 1L : 2L));
        }
    }

    private static void writeEntries(int expectedEntries, BlockBuilder blockBuilder, Type type) {
        for (int i = 0; i < expectedEntries; ++i) {
            TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)TestBlockRetainedSizeBreakdown.castIntegerToObject(i, type));
        }
    }

    private static Object castIntegerToObject(int value, Type type) {
        if (type == IntegerType.INTEGER || type == TinyintType.TINYINT || type == BigintType.BIGINT) {
            return (long)value;
        }
        if (type == VarcharType.VARCHAR) {
            return String.valueOf(value);
        }
        if (type == DoubleType.DOUBLE) {
            return (double)value;
        }
        throw new UnsupportedOperationException();
    }

    private static Block createSliceArrayBlock(int entries) {
        Slice[] sliceArray = new Slice[entries];
        for (int i = 0; i < entries; ++i) {
            sliceArray[i] = Slices.utf8Slice((String)(i + ""));
        }
        return new SliceArrayBlock(sliceArray.length, sliceArray);
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private ObjectStrategy() {
        }

        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object left, Object right) {
            return left == right;
        }
    }
}

