/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.HostAddress;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHostAddress {
    @Test
    public void testEquality() throws Exception {
        HostAddress address1 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1234);
        HostAddress address1NoBrackets = HostAddress.fromParts((String)"1111:2222:3333:4444:5555:6666:7777:8888", (int)1234);
        Assert.assertEquals((Object)address1, (Object)address1NoBrackets);
        HostAddress address1FromString = HostAddress.fromString((String)"[1111:2222:3333:4444:5555:6666:7777:8888]:1234");
        Assert.assertEquals((Object)address1, (Object)address1FromString);
        HostAddress address2 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:9999]", (int)1234);
        Assert.assertNotEquals((Object)address1, (Object)address2);
        HostAddress address3 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1235);
        Assert.assertNotEquals((Object)address1, (Object)address3);
    }

    @Test
    public void testRoundTrip() throws Exception {
        HostAddress address = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1234);
        HostAddress fromParts = HostAddress.fromParts((String)address.getHostText(), (int)address.getPort());
        Assert.assertEquals((Object)address, (Object)fromParts);
        HostAddress fromString = HostAddress.fromString((String)address.toString());
        Assert.assertEquals((Object)address, (Object)fromString);
        Assert.assertEquals((Object)fromParts, (Object)fromString);
    }
}

