/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeSignature {
    @Test
    public void parseSignatureWithLiterals() throws Exception {
        TypeSignature result = TypeSignature.parseTypeSignature((String)"decimal(X,42)", (Set)ImmutableSet.of((Object)"X"));
        Assert.assertEquals((int)result.getParameters().size(), (int)2);
        Assert.assertEquals((boolean)((TypeSignatureParameter)result.getParameters().get(0)).isVariable(), (boolean)true);
        Assert.assertEquals((boolean)((TypeSignatureParameter)result.getParameters().get(1)).isLongLiteral(), (boolean)true);
    }

    @Test
    public void parseRowSignature() throws Exception {
        TestTypeSignature.assertRowSignature("row(a bigint,b varchar)", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", this.varchar())));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"row(col iNt)"), (Object)TypeSignature.parseTypeSignature((String)"row(col integer)"));
        TestTypeSignature.assertRowSignature("ROW(a bigint,b varchar)", "ROW", (List<String>)ImmutableList.of((Object)"a bigint", (Object)"b varchar"), "row(a bigint,b varchar)");
        TestTypeSignature.assertRowSignature("row(a bigint,b array(bigint),c row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.namedParameter("c", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("row(a varchar(10),b row(a bigint))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.varchar(10L)), TestTypeSignature.namedParameter("b", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertRowSignature("array(row(col0 bigint,col1 double))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))));
        TestTypeSignature.assertRowSignature("row(col0 array(row(col0 bigint,col1 double)))", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))))));
        TestTypeSignature.assertRowSignature("row(a decimal(p1,s1),b decimal(p2,s2))", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.decimal("p1", "s1")), TestTypeSignature.namedParameter("b", this.decimal("p2", "s2"))));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"row(a Int(p1))"), (Object)TypeSignature.parseTypeSignature((String)"row(a integer(p1))"));
        TestTypeSignature.assertOldRowSignature("row<bigint,varchar>('a','b')", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", this.varchar())));
        TestTypeSignature.assertOldRowSignature("row<bigint,array(bigint),row<bigint>('a')>('a','b','c')", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint")), TestTypeSignature.namedParameter("b", TestTypeSignature.array(this.signature("bigint"))), TestTypeSignature.namedParameter("c", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertOldRowSignature("row<varchar(10),row<bigint>('a')>('a','b')", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.varchar(10L)), TestTypeSignature.namedParameter("b", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.signature("bigint"))))));
        TestTypeSignature.assertOldRowSignature("array(row<bigint,double>('col0','col1'))", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"array(row<inT>('col'))"), (Object)TypeSignature.parseTypeSignature((String)"array(row<integer>('col'))"));
        TestTypeSignature.assertOldRowSignature("row<array(row<bigint,double>('col0','col1'))>('col0')", TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", TestTypeSignature.array(TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("col0", this.signature("bigint")), TestTypeSignature.namedParameter("col1", this.signature("double")))))));
        TestTypeSignature.assertOldRowSignature("row<decimal(p1,s1),decimal(p2,s2)>('a','b')", (Set<String>)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2"), TestTypeSignature.rowSignature(TestTypeSignature.namedParameter("a", this.decimal("p1", "s1")), TestTypeSignature.namedParameter("b", this.decimal("p2", "s2"))));
    }

    private TypeSignature varchar() {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.of((long)Integer.MAX_VALUE)});
    }

    private TypeSignature varchar(long length) {
        return new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.of((long)length)});
    }

    private TypeSignature decimal(String precisionVariable, String scaleVariable) {
        return new TypeSignature("decimal", (List)ImmutableList.of((Object)TypeSignatureParameter.of((String)precisionVariable), (Object)TypeSignatureParameter.of((String)scaleVariable)));
    }

    private static TypeSignature rowSignature(NamedTypeSignature ... columns) {
        return new TypeSignature("row", Lists.transform(Arrays.asList(columns), TypeSignatureParameter::of));
    }

    private static NamedTypeSignature namedParameter(String name, TypeSignature value) {
        return new NamedTypeSignature(name, value);
    }

    private static TypeSignature array(TypeSignature type) {
        return new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)type)});
    }

    private TypeSignature signature(String name) {
        return new TypeSignature(name, new TypeSignatureParameter[0]);
    }

    @Test
    public void parseSignature() throws Exception {
        TestTypeSignature.assertSignature("bigint", "bigint", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("boolean", "boolean", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("varchar", "varchar", (List<String>)ImmutableList.of((Object)Integer.toString(Integer.MAX_VALUE)));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"int"), (Object)TypeSignature.parseTypeSignature((String)"integer"));
        TestTypeSignature.assertSignature("array(bigint)", "array", (List<String>)ImmutableList.of((Object)"bigint"));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"array(int)"), (Object)TypeSignature.parseTypeSignature((String)"array(integer)"));
        TestTypeSignature.assertSignature("array(array(bigint))", "array", (List<String>)ImmutableList.of((Object)"array(bigint)"));
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"array(array(int))"), (Object)TypeSignature.parseTypeSignature((String)"array(array(integer))"));
        TestTypeSignature.assertSignature("array(timestamp with time zone)", "array", (List<String>)ImmutableList.of((Object)"timestamp with time zone"));
        TestTypeSignature.assertSignature("map(bigint,bigint)", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"bigint"));
        TestTypeSignature.assertSignature("map(bigint,array(bigint))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array(bigint)"));
        TestTypeSignature.assertSignature("map(bigint,map(bigint,map(varchar,bigint)))", "map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"map(bigint,map(varchar,bigint))"));
        this.assertSignatureFail("blah()");
        this.assertSignatureFail("array()");
        this.assertSignatureFail("map()");
        this.assertSignatureFail("x", (Set<String>)ImmutableSet.of((Object)"x"));
        TestTypeSignature.assertSignature("rowxxx<a>", "rowxxx", (List<String>)ImmutableList.of((Object)"a"));
    }

    @Test
    public void parseWithLiteralParameters() {
        TestTypeSignature.assertSignature("foo(42)", "foo", (List<String>)ImmutableList.of((Object)"42"));
        TestTypeSignature.assertSignature("varchar(10)", "varchar", (List<String>)ImmutableList.of((Object)"10"));
    }

    @Test
    public void testVarchar() throws Exception {
        Assert.assertEquals((String)VarcharType.VARCHAR.getTypeSignature().toString(), (String)"varchar");
        Assert.assertEquals((String)VarcharType.createVarcharType((int)42).getTypeSignature().toString(), (String)"varchar(42)");
        Assert.assertEquals((Object)TypeSignature.parseTypeSignature((String)"varchar"), (Object)VarcharType.createUnboundedVarcharType().getTypeSignature());
        Assert.assertEquals((Object)VarcharType.createUnboundedVarcharType().getTypeSignature(), (Object)TypeSignature.parseTypeSignature((String)"varchar"));
        Assert.assertEquals((int)TypeSignature.parseTypeSignature((String)"varchar").hashCode(), (int)VarcharType.createUnboundedVarcharType().getTypeSignature().hashCode());
        Assert.assertNotEquals((Object)VarcharType.createUnboundedVarcharType().getTypeSignature(), (Object)TypeSignature.parseTypeSignature((String)"varchar(10)"));
    }

    @Test
    public void testIsCalculated() throws Exception {
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"bigint").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"decimal(p, s)", (Set)ImmutableSet.of((Object)"p", (Object)"s")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"decimal(2, 1)").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"array(decimal(p, s))", (Set)ImmutableSet.of((Object)"p", (Object)"s")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"array(decimal(2, 1))").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"map(decimal(p1, s1),decimal(p2, s2))", (Set)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"map(decimal(2, 1),decimal(3, 1))").isCalculated());
        Assert.assertTrue((boolean)TypeSignature.parseTypeSignature((String)"row(a decimal(p1,s1),b decimal(p2,s2))", (Set)ImmutableSet.of((Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2")).isCalculated());
        Assert.assertFalse((boolean)TypeSignature.parseTypeSignature((String)"row(a decimal(2,1),b decimal(3,2))").isCalculated());
    }

    private static void assertRowSignature(String typeName, Set<String> literalParameters, TypeSignature expectedSignature) {
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName, literalParameters);
        Assert.assertEquals((Object)signature, (Object)expectedSignature);
        Assert.assertEquals((String)signature.toString(), (String)typeName);
    }

    private static void assertRowSignature(String typeName, TypeSignature expectedSignature) {
        TestTypeSignature.assertRowSignature(typeName, (Set<String>)ImmutableSet.of(), expectedSignature);
    }

    private static void assertSignature(String typeName, String base, List<String> parameters) {
        TestTypeSignature.assertSignature(typeName, base, parameters, typeName.replace("<", "(").replace(">", ")"));
    }

    private static void assertRowSignature(String typeName, String base, List<String> parameters, String expected) {
        TestTypeSignature.assertSignature(typeName, base, parameters, expected);
    }

    @Deprecated
    private static void assertOldRowSignature(String typeName, Set<String> literalParameters, TypeSignature expectedSignature) {
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName, literalParameters);
        Assert.assertEquals((Object)signature, (Object)expectedSignature);
    }

    @Deprecated
    private static void assertOldRowSignature(String typeName, TypeSignature expectedSignature) {
        TestTypeSignature.assertOldRowSignature(typeName, (Set<String>)ImmutableSet.of(), expectedSignature);
    }

    private static void assertSignature(String typeName, String base, List<String> parameters, String expectedTypeName) {
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName);
        Assert.assertEquals((String)signature.getBase(), (String)base);
        Assert.assertEquals((int)signature.getParameters().size(), (int)parameters.size());
        for (int i = 0; i < signature.getParameters().size(); ++i) {
            Assert.assertEquals((String)((TypeSignatureParameter)signature.getParameters().get(i)).toString(), (String)parameters.get(i));
        }
        Assert.assertEquals((String)signature.toString(), (String)expectedTypeName);
    }

    private void assertSignatureFail(String typeName) {
        try {
            TypeSignature.parseTypeSignature((String)typeName);
            Assert.fail((String)"Type signatures with zero parameters should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void assertSignatureFail(String typeName, Set<String> literalCalculationParameters) {
        try {
            TypeSignature.parseTypeSignature((String)typeName, literalCalculationParameters);
            Assert.fail((String)"Type signatures with zero parameters should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

