/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.LongDecimalType;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongDecimalType {
    private static final LongDecimalType TYPE = (LongDecimalType)LongDecimalType.createDecimalType((int)20, (int)10);

    @Test
    public void testCompareTo() throws Exception {
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567890", 0);
        this.testCompare("1234567890.1234567890", "1234567890.1234567891", -1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567889", 1);
        this.testCompare("1234567890.1234567890", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "1234567889.1234567890", 1);
        this.testCompare("0", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "0", 1);
        this.testCompare("0", "0", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567890", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567891", 1);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567889", -1);
        this.testCompare("-1234567890.1234567890", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "-1234567889.1234567890", -1);
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "0", -1);
        this.testCompare("-1234567890.1234567890", "1234567890.1234567890", -1);
        this.testCompare("1234567890.1234567890", "-1234567890.1234567890", 1);
    }

    private void testCompare(String decimalA, String decimalB, int expected) {
        int actual = TYPE.compareTo(this.decimalAsBlock(decimalA), 0, this.decimalAsBlock(decimalB), 0);
        Assert.assertEquals((int)((int)Math.signum(actual)), (int)((int)Math.signum(expected)), (String)("bad comparison result for " + decimalA + ", " + decimalB));
    }

    private Block decimalAsBlock(String value) {
        Slice slice = Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus(), 1, slice.length());
        TYPE.writeSlice((BlockBuilder)blockBuilder, slice);
        return blockBuilder.build();
    }
}

