/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.TestingBlockEncodingSerde;
import com.facebook.presto.spi.block.TestingBlockJsonSerde;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TestingTypeDeserializer;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRange {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMismatchedTypes() throws Exception {
        new Range(Marker.exactly((Type)BigintType.BIGINT, (Object)1L), Marker.exactly((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvertedBounds() throws Exception {
        new Range(Marker.exactly((Type)BigintType.BIGINT, (Object)1L), Marker.exactly((Type)BigintType.BIGINT, (Object)0L));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLowerUnboundedOnly() throws Exception {
        new Range(Marker.lowerUnbounded((Type)BigintType.BIGINT), Marker.lowerUnbounded((Type)BigintType.BIGINT));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUpperUnboundedOnly() throws Exception {
        new Range(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.upperUnbounded((Type)BigintType.BIGINT));
    }

    @Test
    public void testSingleValue() throws Exception {
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)1L, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)DoubleType.DOUBLE, (Object)1.1, (boolean)true, (Object)1.1, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"), (boolean)true, (Object)Slices.utf8Slice((String)"a"), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)true, (boolean)true, (Object)true, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)false, (boolean)true, (Object)true, (boolean)true).isSingleValue());
    }

    @Test
    public void testAllRange() throws Exception {
        Range range = Range.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertTrue((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)range.includes(Marker.below((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.above((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGreaterThanRange() throws Exception {
        Range range = Range.greaterThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGreaterThanOrEqualRange() throws Exception {
        Range range = Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testLessThanRange() throws Exception {
        Range range = Range.lessThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testLessThanOrEqualRange() throws Exception {
        Range range = Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testEqualRange() throws Exception {
        Range range = Range.equal((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertTrue((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testRange() throws Exception {
        Range range = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)true);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)2L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)3L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L).getSingleValue(), (Object)0L);
        try {
            Range.lessThan((Type)BigintType.BIGINT, (Object)0L).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.lessThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false)));
    }

    @Test
    public void testSpan() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.equal((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)10L, (boolean)false));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.equal((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.lessThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.all((Type)BigintType.BIGINT).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).overlaps(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).overlaps(Range.lessThan((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE)));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).intersect(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)true));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.equal((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)2L));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)3L));
        Assert.assertEquals((Object)Range.all((Type)BigintType.BIGINT).intersect(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE));
    }

    @Test
    public void testExceptionalIntersect() throws Exception {
        try {
            Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).intersect(Range.lessThan((Type)BigintType.BIGINT, (Object)2L));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde((TypeManager)typeManager, new BlockEncodingFactory[0]);
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        Range range = Range.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.equal((Type)DoubleType.DOUBLE, (Object)0.123);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThan((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThan((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)Double.MAX_VALUE);
        Assert.assertEquals((Object)range, (Object)mapper.readValue(mapper.writeValueAsString((Object)range), Range.class));
    }
}

