/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.TestingBlockEncodingSerde;
import com.facebook.presto.spi.block.TestingBlockJsonSerde;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TestingTypeDeserializer;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMarker {
    @Test
    public void testTypes() throws Exception {
        Assert.assertEquals((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.upperUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testUnbounded() throws Exception {
        Assert.assertTrue((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertTrue((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
    }

    @Test
    public void testComparisons() throws Exception {
        ImmutableList markers = ImmutableList.of((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)markers));
        for (int i = 0; i < markers.size(); ++i) {
            for (int j = 0; j < markers.size(); ++j) {
                Assert.assertTrue((((Marker)markers.get(i)).compareTo((Marker)markers.get(j)) == Integer.compare(i, j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testAdjacency() throws Exception {
        ImmutableMap markers = ImmutableMap.builder().put((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)-1000).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)-100).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)-1).put((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)0).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)1).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)100).put((Object)Marker.upperUnbounded((Type)BigintType.BIGINT), (Object)1000).build();
        for (Map.Entry entry1 : markers.entrySet()) {
            for (Map.Entry entry2 : markers.entrySet()) {
                boolean adjacent = ((Marker)entry1.getKey()).isAdjacent((Marker)entry2.getKey());
                boolean distanceIsOne = Math.abs((Integer)entry1.getValue() - (Integer)entry2.getValue()) == 1;
                Assert.assertEquals((boolean)adjacent, (boolean)distanceIsOne);
            }
        }
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L));
        try {
            Marker.below((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.above((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((Type)BigintType.BIGINT).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((Type)BigintType.BIGINT).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((Type)BigintType.BIGINT).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((Type)BigintType.BIGINT).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde((TypeManager)typeManager, new BlockEncodingFactory[0]);
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        Marker marker = Marker.above((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.below((Type)DoubleType.DOUBLE, (Object)0.123);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)BooleanType.BOOLEAN, (Object)true);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.upperUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.lowerUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
    }
}

