/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.predicate;

import com.facebook.presto.spi.predicate.AllOrNoneValueSet;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.TestingTypeDeserializer;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAllOrNoneValueSet {
    @Test
    public void testAll() throws Exception {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)valueSet.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)valueSet.isNone());
        Assert.assertTrue((boolean)valueSet.isAll());
        Assert.assertFalse((boolean)valueSet.isSingleValue());
        Assert.assertTrue((boolean)valueSet.containsValue((Object)Slices.EMPTY_SLICE));
        try {
            valueSet.getSingleValue();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNone() throws Exception {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)valueSet.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)valueSet.isNone());
        Assert.assertFalse((boolean)valueSet.isAll());
        Assert.assertFalse((boolean)valueSet.isSingleValue());
        Assert.assertFalse((boolean)valueSet.containsValue((Object)Slices.EMPTY_SLICE));
        try {
            valueSet.getSingleValue();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIntersect() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)all.intersect((ValueSet)all), (Object)all);
        Assert.assertEquals((Object)all.intersect((ValueSet)none), (Object)none);
        Assert.assertEquals((Object)none.intersect((ValueSet)all), (Object)none);
        Assert.assertEquals((Object)none.intersect((ValueSet)none), (Object)none);
    }

    @Test
    public void testUnion() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)all.union((ValueSet)all), (Object)all);
        Assert.assertEquals((Object)all.union((ValueSet)none), (Object)all);
        Assert.assertEquals((Object)none.union((ValueSet)all), (Object)all);
        Assert.assertEquals((Object)none.union((ValueSet)none), (Object)none);
    }

    @Test
    public void testComplement() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)all.complement(), (Object)none);
        Assert.assertEquals((Object)none.complement(), (Object)all);
    }

    @Test
    public void testOverlaps() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)all.overlaps((ValueSet)all));
        Assert.assertFalse((boolean)all.overlaps((ValueSet)none));
        Assert.assertFalse((boolean)none.overlaps((ValueSet)all));
        Assert.assertFalse((boolean)none.overlaps((ValueSet)none));
    }

    @Test
    public void testSubtract() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)all.subtract((ValueSet)all), (Object)none);
        Assert.assertEquals((Object)all.subtract((ValueSet)none), (Object)all);
        Assert.assertEquals((Object)none.subtract((ValueSet)all), (Object)none);
        Assert.assertEquals((Object)none.subtract((ValueSet)none), (Object)none);
    }

    @Test
    public void testContains() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)all.contains((ValueSet)all));
        Assert.assertTrue((boolean)all.contains((ValueSet)none));
        Assert.assertFalse((boolean)none.contains((ValueSet)all));
        Assert.assertTrue((boolean)none.contains((ValueSet)none));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)));
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)all, (Object)mapper.readValue(mapper.writeValueAsString((Object)all), AllOrNoneValueSet.class));
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)none, (Object)mapper.readValue(mapper.writeValueAsString((Object)none), AllOrNoneValueSet.class));
    }
}

